/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.auth;

import java.util.List;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.config.auth.CredentialParams;
import org.pipservices4.config.auth.ICredentialStore;

public class MemoryCredentialStore
implements ICredentialStore,
IReconfigurable {
    private final AnyValueMap _items = new AnyValueMap();
    private final Object _lock = new Object();

    public MemoryCredentialStore() {
    }

    public MemoryCredentialStore(ConfigParams credentials) {
        this.configure(credentials);
    }

    @Override
    public void configure(ConfigParams config) {
        this.readCredentials(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCredentials(ConfigParams config) {
        Object object = this._lock;
        synchronized (object) {
            this._items.clear();
            List<String> sections = config.getSectionNames();
            for (String section : sections) {
                ConfigParams value = config.getSection(section);
                this._items.append(CredentialParams.fromTuples(section, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(IContext context, String key, CredentialParams credential) {
        Object object = this._lock;
        synchronized (object) {
            if (credential != null) {
                this._items.put(key, credential);
            } else {
                this._items.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialParams lookup(IContext context, String key) {
        Object object = this._lock;
        synchronized (object) {
            if (this._items.get(key) instanceof String) {
                return CredentialParams.fromString((String)this._items.get(key));
            }
            return (CredentialParams)this._items.get(key);
        }
    }
}

