/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.refer;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.Reference;
import org.pipservices4.components.refer.ReferenceException;

public class References
implements IReferences {
    protected List<Reference> _references = new ArrayList<Reference>();
    protected final Object _lock = new Object();

    public References() {
    }

    public References(Object[] tuples) {
        if (tuples != null) {
            for (int index = 0; index < tuples.length && index + 1 < tuples.length; index += 2) {
                this.put(tuples[index], tuples[index + 1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object locator, Object component) throws NullPointerException {
        if (component == null) {
            throw new NullPointerException("Reference cannot be null");
        }
        Object object = this._lock;
        synchronized (object) {
            this._references.add(new Reference(locator, component));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object locator) {
        if (locator == null) {
            return null;
        }
        Object object = this._lock;
        synchronized (object) {
            for (int index = this._references.size() - 1; index >= 0; --index) {
                Reference reference = this._references.get(index);
                if (!reference.match(locator)) continue;
                this._references.remove(index);
                return reference.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> removeAll(Object locator) {
        ArrayList<Object> components = new ArrayList<Object>();
        if (locator == null) {
            return components;
        }
        Object object = this._lock;
        synchronized (object) {
            for (int index = this._references.size() - 1; index >= 0; --index) {
                Reference reference = this._references.get(index);
                if (!reference.match(locator)) continue;
                this._references.remove(index);
                components.add(reference.getComponent());
            }
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllLocators() {
        ArrayList<Object> locators = new ArrayList<Object>();
        Object object = this._lock;
        synchronized (object) {
            for (Reference reference : this._references) {
                locators.add(reference.getLocator());
            }
        }
        return locators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAll() {
        ArrayList<Object> components = new ArrayList<Object>();
        Object object = this._lock;
        synchronized (object) {
            for (Reference reference : this._references) {
                components.add(reference.getComponent());
            }
        }
        return components;
    }

    @Override
    public Object getOneOptional(Object locator) {
        try {
            List<Object> components = this.find(Object.class, locator, false);
            return !components.isEmpty() ? components.get(0) : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public <T> T getOneOptional(Class<T> type, Object locator) {
        try {
            List<T> components = this.find(type, locator, false);
            return !components.isEmpty() ? (T)components.get(0) : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Object getOneRequired(Object locator) throws ReferenceException {
        List<Object> components = this.find(Object.class, locator, true);
        return !components.isEmpty() ? components.get(0) : null;
    }

    @Override
    public <T> T getOneRequired(Class<T> type, Object locator) throws ReferenceException {
        List<T> components = this.find(type, locator, true);
        return !components.isEmpty() ? (T)components.get(0) : null;
    }

    @Override
    public List<Object> getOptional(Object locator) {
        try {
            return this.find(Object.class, locator, false);
        }
        catch (Exception ex) {
            return new ArrayList<Object>();
        }
    }

    @Override
    public <T> List<T> getOptional(Class<T> type, Object locator) {
        try {
            return this.find(type, locator, false);
        }
        catch (Exception ex) {
            return new ArrayList();
        }
    }

    @Override
    public List<Object> getRequired(Object locator) throws ReferenceException {
        return this.find(Object.class, locator, true);
    }

    @Override
    public <T> List<T> getRequired(Class<T> type, Object locator) throws ReferenceException {
        return this.find(type, locator, true);
    }

    @Override
    public List<Object> find(Object locator, boolean required) throws ReferenceException {
        return this.find(Object.class, locator, required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> find(Class<T> type, Object locator, boolean required) throws ReferenceException {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator cannot be null");
        }
        ArrayList<Object> components = new ArrayList<Object>();
        Object object = this._lock;
        synchronized (object) {
            for (int index = this._references.size() - 1; index >= 0; --index) {
                Object component;
                Reference reference = this._references.get(index);
                if (!reference.match(locator) || !type.isInstance(component = reference.getComponent())) continue;
                components.add(component);
            }
        }
        if (components.isEmpty() && required) {
            throw new ReferenceException(null, locator);
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._references.clear();
        }
    }

    public static References fromTuples(Object ... tuples) throws ReferenceException {
        return new References(tuples);
    }
}

