/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.data.StringValueMap;
import org.pipservices4.commons.reflect.RecursiveObjectReader;

public class ConfigParams
extends StringValueMap {
    private static final long serialVersionUID = 671946442626850877L;

    public ConfigParams() {
    }

    public ConfigParams(Map<?, ?> values) {
        super(values);
    }

    public List<String> getSectionNames() {
        ArrayList<String> sections = new ArrayList<String>();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            int pos = key.indexOf(46);
            if (pos > 0) {
                key = key.substring(0, pos);
            }
            boolean found = false;
            for (String section : sections) {
                if (!section.equalsIgnoreCase(key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            sections.add(key);
        }
        return sections;
    }

    public ConfigParams getSection(String section) {
        ConfigParams result = new ConfigParams();
        String prefix = section + ".";
        for (Map.Entry entry : this.entrySet()) {
            String keyPrefix;
            String key = (String)entry.getKey();
            if (key.length() < prefix.length() || !(keyPrefix = key.substring(0, prefix.length())).equalsIgnoreCase(prefix)) continue;
            key = key.substring(prefix.length());
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    public void addSection(String section, ConfigParams sectionParams) {
        if (section == null) {
            throw new NullPointerException("Section name cannot be null");
        }
        if (sectionParams != null) {
            for (Map.Entry entry : sectionParams.entrySet()) {
                Object key = (String)entry.getKey();
                if (!((String)key).isEmpty() && !section.isEmpty()) {
                    key = section + "." + (String)key;
                } else if (((String)key).isEmpty()) {
                    key = section;
                }
                String value = (String)entry.getValue();
                this.put(key, value);
            }
        }
    }

    public ConfigParams override(ConfigParams configParams) {
        StringValueMap map = StringValueMap.fromMaps(this, configParams);
        return new ConfigParams((Map<?, ?>)map);
    }

    public ConfigParams setDefaults(ConfigParams defaultConfigParams) {
        StringValueMap map = StringValueMap.fromMaps(defaultConfigParams, this);
        return new ConfigParams((Map<?, ?>)map);
    }

    public static ConfigParams fromValue(Object value) {
        Map<String, Object> map = RecursiveObjectReader.getProperties(value);
        return new ConfigParams(map);
    }

    public static ConfigParams fromTuples(Object ... tuples) {
        StringValueMap map = StringValueMap.fromTuplesArray(tuples);
        return new ConfigParams((Map<?, ?>)map);
    }

    public static ConfigParams fromString(String line) {
        StringValueMap map = StringValueMap.fromString(line);
        return new ConfigParams((Map<?, ?>)map);
    }

    public static ConfigParams mergeConfigs(ConfigParams ... configs) {
        StringValueMap map = StringValueMap.fromMaps(configs);
        return new ConfigParams((Map<?, ?>)map);
    }
}

