/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.prometheus.count;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.net.InetAddress;
import java.util.List;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.HttpConnectionResolver;
import org.pipservices4.observability.count.CachedCounters;
import org.pipservices4.observability.count.Counter;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.prometheus.count.PrometheusCounterConverter;

public class PrometheusCounters
extends CachedCounters
implements IReferenceable,
IOpenable,
IConfigurable {
    private String _baseRoute;
    private final CompositeLogger _logger = new CompositeLogger();
    private final HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    private boolean _opened = false;
    private String _source;
    private String _instance;
    private boolean _pushEnabled;
    private Client _client;
    private String _requestRoute;

    public void configure(ConfigParams config) {
        super.configure(config);
        this._connectionResolver.configure(config);
        this._source = config.getAsStringWithDefault("source", this._source);
        this._instance = config.getAsStringWithDefault("instance", this._instance);
        this._pushEnabled = config.getAsBooleanWithDefault("push_enabled", true);
    }

    public void setReferences(IReferences references) {
        this._logger.setReferences(references);
        this._connectionResolver.setReferences(references);
        ContextInfo contextInfo = (ContextInfo)references.getOneOptional(ContextInfo.class, (Object)new Descriptor("pip-services", "context-info", "default", "*", "1.0"));
        if (contextInfo != null && this._source == null) {
            this._source = contextInfo.getName();
        }
        if (contextInfo != null && this._instance == null) {
            this._instance = contextInfo.getContextId();
        }
    }

    public boolean isOpen() {
        return this._opened;
    }

    public void open(IContext context) {
        if (this._opened) {
            return;
        }
        if (!this._pushEnabled) {
            return;
        }
        this._opened = true;
        try {
            ConnectionParams connection = this._connectionResolver.resolve(context);
            this._baseRoute = connection.getAsString("uri");
            String job = this._source != null ? this._source : "unknown";
            String instance = this._instance != null ? this._instance : InetAddress.getLocalHost().getHostName();
            this._requestRoute = "/metrics/job/" + job + "/instance/" + instance;
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.register((Object)new JacksonFeature());
            this._client = ClientBuilder.newClient((Configuration)clientConfig);
        }
        catch (Exception ex) {
            this._client = null;
            this._logger.warn(context, "Connection to Prometheus server is not configured: " + ex, new Object[0]);
        }
    }

    public void close(IContext context) {
        if (this._client != null) {
            this._client.close();
        }
        this._opened = false;
        this._client = null;
        this._requestRoute = null;
    }

    protected void save(List<Counter> counters) {
        if (this._client == null || !this._pushEnabled) {
            return;
        }
        String body = PrometheusCounterConverter.toString(counters, null, null);
        try (Response response = this._client.target(this._baseRoute + this._requestRoute).request(new String[]{"application/json"}).put(Entity.entity((Object)body, (String)"application/json"));){
            if (response.getStatus() >= 400) {
                this._logger.error((IContext)Context.fromTraceId((String)"prometheus-counters"), (String)response.readEntity(String.class), new Object[]{"Failed to push metrics to prometheus"});
            }
        }
    }
}

