/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.prometheus.count;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.observability.count.Counter;

public class PrometheusCounterConverter {
    public static String toString(List<Counter> counters, String source, String instance) {
        if (counters == null || counters.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Counter counter : counters) {
            String counterName = PrometheusCounterConverter.parseCounterName(counter);
            String labels = PrometheusCounterConverter.generateCounterLabel(counter, source, instance);
            switch (counter.getType()) {
                case 4: {
                    builder.append("# TYPE ").append(counterName).append(" gauge\n");
                    builder.append(counterName).append(labels).append(" ").append(StringConverter.toString((Object)counter.getCount())).append("\n");
                    break;
                }
                case 0: 
                case 2: {
                    builder.append("# TYPE ").append(counterName).append("_max gauge\n");
                    builder.append(counterName).append("_max").append(labels).append(" ").append(StringConverter.toString((Object)counter.getMax())).append("\n");
                    builder.append("# TYPE ").append(counterName).append("_min gauge\n");
                    builder.append(counterName).append("_min").append(labels).append(" ").append(StringConverter.toString((Object)counter.getMin())).append("\n");
                    builder.append("# TYPE ").append(counterName).append("_average gauge\n");
                    builder.append(counterName).append("_average").append(labels).append(" ").append(StringConverter.toString((Object)counter.getAverage())).append("\n");
                    builder.append("# TYPE ").append(counterName).append("_count gauge\n");
                    builder.append(counterName).append("_count").append(labels).append(" ").append(StringConverter.toString((Object)counter.getCount())).append("\n");
                    break;
                }
                case 1: {
                    builder.append("# TYPE ").append(counterName).append(" gauge\n");
                    builder.append(counterName).append(labels).append(" ").append(StringConverter.toString((Object)counter.getLast())).append("\n");
                }
            }
        }
        return builder.toString();
    }

    private static String generateCounterLabel(Counter counter, String source, String instance) {
        String[] nameParts;
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        if (source != null && !source.equals("")) {
            labels.put("source", source);
        }
        if (instance != null && !instance.equals("")) {
            labels.put("instance", instance);
        }
        if ((nameParts = counter.getName().split("\\.")).length >= 3 && Objects.equals(nameParts[2], "exec_count") || nameParts.length >= 3 && Objects.equals(nameParts[2], "exec_time") || nameParts.length >= 3 && Objects.equals(nameParts[2], "exec_errors")) {
            labels.put("service", nameParts[0]);
            labels.put("command", nameParts[1]);
        }
        if (nameParts.length >= 4 && Objects.equals(nameParts[3], "call_count") || nameParts.length >= 4 && Objects.equals(nameParts[3], "call_time") || nameParts.length >= 4 && Objects.equals(nameParts[3], "call_errors")) {
            labels.put("service", nameParts[1]);
            labels.put("command", nameParts[2]);
            labels.put("target", nameParts[0]);
        }
        if (nameParts.length >= 3 && Objects.equals(nameParts[2], "sent_messages") || nameParts.length >= 3 && Objects.equals(nameParts[2], "received_messages") || nameParts.length >= 3 && Objects.equals(nameParts[2], "dead_messages")) {
            labels.put("queue", nameParts[1]);
        }
        if (labels.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("{");
        for (String key : labels.keySet()) {
            if (builder.length() > 1) {
                builder.append(",");
            }
            builder.append(key).append("=\"").append((String)labels.get(key)).append('\"');
        }
        builder.append("}");
        return builder.toString();
    }

    private static String parseCounterName(Counter counter) {
        if (counter == null || counter.getName() == null || Objects.equals(counter.getName(), "")) {
            return "";
        }
        String[] nameParts = counter.getName().split("\\.");
        if (nameParts.length >= 3 && Objects.equals(nameParts[2], "exec_count")) {
            return nameParts[2];
        }
        if (nameParts.length >= 3 && Objects.equals(nameParts[2], "exec_time")) {
            return nameParts[2];
        }
        if (nameParts.length >= 3 && Objects.equals(nameParts[2], "exec_errors")) {
            return nameParts[2];
        }
        if (nameParts.length >= 4 && Objects.equals(nameParts[3], "call_count")) {
            return nameParts[3];
        }
        if (nameParts.length >= 4 && Objects.equals(nameParts[3], "call_time")) {
            return nameParts[3];
        }
        if (nameParts.length >= 4 && Objects.equals(nameParts[3], "call_errors")) {
            return nameParts[3];
        }
        if (nameParts.length >= 3 && Objects.equals(nameParts[2], "sent_messages") || nameParts.length >= 3 && Objects.equals(nameParts[2], "received_messages") || nameParts.length >= 3 && Objects.equals(nameParts[2], "dead_messages")) {
            String name = nameParts[0] + "." + nameParts[2];
            return name.toLowerCase().replace(".", "_").replace("/", "_");
        }
        return counter.getName().toLowerCase().replace(".", "_").replace("/", "_");
    }

    private static Map<String, String> parseCounterLabels(Counter counter, String source, String instance) {
        String[] nameParts;
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        if (source != null && !source.equals("")) {
            labels.put("source", source);
        }
        if (instance != null && !instance.equals("")) {
            labels.put("instance", instance);
        }
        if ((nameParts = counter.getName().split("\\.")).length >= 3 && Objects.equals(nameParts[2], "exec_time")) {
            labels.put("service", nameParts[0]);
            labels.put("command", nameParts[1]);
        }
        return labels;
    }
}

