#!/usr/bin/env pwsh

param
(
    [Parameter(Mandatory = $true, Position = 0)]
    [string] $Product
)

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Update baseline
Write-Host "Updating '$Product' to baseline '$($component.baseline)'"
helm upgrade $Product "$PSScriptRoot/../../../package-$Product-ps/$Product" `
    --reuse-values --set "baseline=$($component.baseline)" -n $Product

# Check for error
if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to execute helm update."
}
