#!/usr/bin/env pwsh

param
(
    [Parameter(Mandatory = $true, Position = 0)]
    [string] $Org,

    [Parameter(Mandatory = $true, Position = 1)]
    [string] $Name,

    [Parameter(Mandatory = $true, Position = 2)]
    [string] $AWSSecretKeyId,

    [Parameter(Mandatory = $true, Position = 3)]
    [string] $AWSSecretAccessKey,

    [Parameter(Mandatory = $true, Position = 4)]
    [string] $AWSS3Bucket,

    [Parameter(Mandatory = $true, Position = 5)]
    [string] $AWSS3BucketFolder,

    [Parameter(Mandatory = $true, Position = 6)]
    [string] $Token,

    [Parameter(Mandatory = $false, Position = 7)]
    [string] $JenkinsUrl
)

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../common/include.ps1"
. "$PSScriptRoot/measure_common.ps1"

# Verify build server and set environment variable
Set-EnvBuildServer

# AWS Auth by environment variables
$env:AWS_ACCESS_KEY_ID = $AWSSecretKeyId
$env:AWS_SECRET_ACCESS_KEY = $AWSSecretAccessKey
$env:AWS_DEFAULT_REGION = "us-east-1"

switch ($env:BUILD_SERVER) {
    "gitlab" {
        . "$PSScriptRoot/measure_gitlab.ps1" $Org $Name $AWSSecretKeyId $AWSSecretAccessKey $AWSS3Bucket $AWSS3BucketFolder $Token
    }
    "github" {
        . "$PSScriptRoot/measure_github.ps1" $Org $Name $AWSSecretKeyId $AWSSecretAccessKey $AWSS3Bucket $AWSS3BucketFolder $Token
    }
    "jenkins" {
        . "$PSScriptRoot/measure_jenkins.ps1" $Org $Name $AWSSecretKeyId $AWSSecretAccessKey $AWSS3Bucket $AWSS3BucketFolder $Token $JenkinsUrl
    }
    "azure" {
        . "$PSScriptRoot/measure_azure.ps1" $Org $Name $AWSSecretKeyId $AWSSecretAccessKey $AWSS3Bucket $AWSS3BucketFolder $Token
    }
    "bitbucket" {
        . "$PSScriptRoot/measure_bitbucket.ps1" $Org $Name $AWSSecretKeyId $AWSSecretAccessKey $AWSS3Bucket $AWSS3BucketFolder
    }
    Default {
        Write-Host "Build server not supported"
    }
}