#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Get publish artifact
$pypiArtifact = $component.artifacts | Where-Object {$_.type -eq "pypi"}

# Skip publish if artifact not set
if ($pypiArtifact -eq $null) {
    Write-Host "Didn't find any artifacts of the type 'pypi' in component.json. Publish to pypi skipped."
    exit 0
}

# Create pypirc if not exists
if (-not (Test-Path "~/.pypirc")) {
    $pypircContent = @"
[distutils]
index-servers=
    testpypi
    pypi
[testpypi]
repository = https://test.pypi.org/legacy/
username = $($env:PYPI_USER)
password = $($env:PYPI_PASS)
[pypi]
repository = https://upload.pypi.org/legacy/
username = $($env:PYPI_USER)
password = $($env:PYPI_PASS)
"@

    Set-Content -Path "~/.pypirc" -Value $pypircContent
}

# Publish package
Write-Host "Pushing package to pypi"
python -m pip install --upgrade build
python -m build "$PSScriptRoot/../../../"
python -m pip install --upgrade twine
python -m twine upload --skip-existing "$PSScriptRoot/../../../dist/*"

if ($LastExitCode -ne 0) {
    Write-Error "Publish failed. See logs above for more information."
}
