/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.rpc.commands;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.rpc.commands.IEvent;
import org.pipservices4.rpc.commands.IEventListener;

public class Event
implements IEvent {
    private final String _name;
    private final List<IEventListener> _listeners = new ArrayList<IEventListener>();

    public Event(String name) {
        if (name == null) {
            throw new NullPointerException("Event name is not set");
        }
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public List<IEventListener> getListeners() {
        return this._listeners;
    }

    @Override
    public void addListener(IEventListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(IEventListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public void notify(IContext context, Parameters args) throws ApplicationException {
        for (IEventListener listener : this._listeners) {
            try {
                listener.onEvent(context, this, args);
            }
            catch (Exception ex) {
                throw new InvocationException(context != null ? ContextResolver.getTraceId(context) : null, "EXEC_FAILED", "Rasing event " + this._name + " failed: " + String.valueOf(ex)).withDetails("event", this._name).wrap(ex);
            }
        }
    }
}

