/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.prometheus.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.http.controllers.RestController;
import org.pipservices4.observability.count.CachedCounters;
import org.pipservices4.observability.count.Counter;
import org.pipservices4.prometheus.count.PrometheusCounterConverter;
import org.pipservices4.prometheus.count.PrometheusCounters;

public class PrometheusMetricsController
extends RestController {
    private CachedCounters _cachedCounters;
    private String _source;
    private String _instance;

    public PrometheusMetricsController() {
        this._dependencyResolver.put("cached-counters", new Descriptor("pip-services", "counters", "cached", "*", "1.0"));
        this._dependencyResolver.put("prometheus-counters", new Descriptor("pip-services", "counters", "prometheus", "*", "1.0"));
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        ContextInfo contextInfo;
        super.setReferences(references);
        this._cachedCounters = this._dependencyResolver.getOneOptional(PrometheusCounters.class, "prometheus-counters");
        if (this._cachedCounters == null) {
            this._cachedCounters = this._dependencyResolver.getOneOptional(CachedCounters.class, "cached-counters");
        }
        if ((contextInfo = references.getOneOptional(ContextInfo.class, new Descriptor("pip-services", "context-info", "default", "*", "1.0"))) != null && (Objects.equals(this._source, "") || this._source == null)) {
            this._source = contextInfo.getName();
        }
        if (contextInfo != null && (Objects.equals(this._instance, "") || this._instance == null)) {
            this._instance = contextInfo.getContextId();
        }
    }

    @Override
    public void register() {
        this.registerRoute("get", "metrics", null, this::metrics);
        this.registerRoute("get", "metricsandreset", null, this::metricsAndReset);
    }

    public Response metrics(ContainerRequestContext req) {
        List<Counter> counters = this._cachedCounters != null ? this._cachedCounters.getAll() : null;
        String body = PrometheusCounterConverter.toString(counters, this._source, this._instance);
        return Response.status(Response.Status.OK).type("text/plain").entity(body).build();
    }

    private Response metricsAndReset(ContainerRequestContext req) {
        List<Counter> counters = this._cachedCounters != null ? this._cachedCounters.getAll() : null;
        String body = PrometheusCounterConverter.toString(counters, this._source, this._instance);
        if (this._cachedCounters != null) {
            this._cachedCounters.clearAll();
        }
        return Response.status(Response.Status.OK).type("text/plain").entity(body).build();
    }
}

