/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.trace;

import org.pipservices4.components.context.IContext;
import org.pipservices4.observability.trace.ITracer;

public class TraceTiming {
    private final long _start;
    private final ITracer _tracer;
    private final IContext _context;
    private final String _component;
    private final String _operation;

    public TraceTiming(IContext context, String component, String operation) {
        this._context = context;
        this._component = component;
        this._operation = operation;
        this._tracer = null;
        this._start = System.currentTimeMillis();
    }

    public TraceTiming(IContext context, String component, String operation, ITracer tracer) {
        this._context = context;
        this._component = component;
        this._operation = operation;
        this._tracer = tracer;
        this._start = System.currentTimeMillis();
    }

    public void endTrace() {
        if (this._tracer != null) {
            long elapsed = System.currentTimeMillis() - this._start;
            this._tracer.trace(this._context, this._component, this._operation, elapsed);
        }
    }

    public void endFailure(Exception error) {
        if (this._tracer != null) {
            long elapsed = System.currentTimeMillis() - this._start;
            this._tracer.failure(this._context, this._component, this._operation, error, elapsed);
        }
    }
}

