/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.trace;

import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.log.LogLevel;
import org.pipservices4.observability.log.LogLevelConverter;
import org.pipservices4.observability.trace.ITracer;
import org.pipservices4.observability.trace.TraceTiming;

public class LogTracer
implements IConfigurable,
IReferenceable,
ITracer {
    private final CompositeLogger _logger = new CompositeLogger();
    private LogLevel _logLevel = LogLevel.Debug;

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._logLevel = LogLevelConverter.toLogLevel(config.getAsObject("options.log_level"), this._logLevel);
    }

    @Override
    public void setReferences(IReferences references) {
        this._logger.setReferences(references);
    }

    private void logTrace(IContext context, String component, String operation, Exception error, long duration) {
        StringBuilder builder = new StringBuilder();
        if (error != null) {
            builder.append("Failed to execute ");
        } else {
            builder.append("Executed ");
        }
        builder.append(component);
        if (operation != null && !operation.isEmpty()) {
            builder.append(".");
            builder.append(operation);
        }
        if (duration > 0L) {
            builder.append(" in ").append(duration).append(" msec");
        }
        if (error != null) {
            this._logger.error(context, String.valueOf(error), builder);
        } else {
            this._logger.log(this._logLevel, context, null, String.valueOf(builder), new Object[0]);
        }
    }

    @Override
    public void trace(IContext context, String component, String operation, Long duration) {
        this.logTrace(context, component, operation, null, duration);
    }

    @Override
    public void failure(IContext context, String component, String operation, Exception error, long duration) {
        this.logTrace(context, component, operation, error, duration);
    }

    @Override
    public TraceTiming beginTrace(IContext context, String component, String operation) {
        return new TraceTiming(context, component, operation, this);
    }
}

