/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.log;

import org.pipservices4.observability.log.LogLevel;

public class LogLevelConverter {
    public static LogLevel toLogLevel(Object value) {
        return LogLevelConverter.toLogLevel(value, null);
    }

    public static LogLevel toLogLevel(Object value, LogLevel defaultValue) {
        if (defaultValue == null) {
            defaultValue = LogLevel.Info;
        }
        if (value == null) {
            return LogLevel.Info;
        }
        if ("0".equals(value = value.toString().toUpperCase()) || "NOTHING".equals(value) || "NONE".equals(value)) {
            return LogLevel.None;
        }
        if ("1".equals(value) || "FATAL".equals(value)) {
            return LogLevel.Fatal;
        }
        if ("2".equals(value) || "ERROR".equals(value)) {
            return LogLevel.Error;
        }
        if ("3".equals(value) || "WARN".equals(value) || "WARNING".equals(value)) {
            return LogLevel.Warn;
        }
        if ("4".equals(value) || "INFO".equals(value)) {
            return LogLevel.Info;
        }
        if ("5".equals(value) || "DEBUG".equals(value)) {
            return LogLevel.Debug;
        }
        if ("6".equals(value) || "TRACE".equals(value)) {
            return LogLevel.Trace;
        }
        return defaultValue;
    }

    public static String toString(LogLevel level) {
        if (level == LogLevel.Fatal) {
            return "FATAL";
        }
        if (level == LogLevel.Error) {
            return "ERROR";
        }
        if (level == LogLevel.Warn) {
            return "WARN";
        }
        if (level == LogLevel.Info) {
            return "INFO";
        }
        if (level == LogLevel.Debug) {
            return "DEBUG";
        }
        if (level == LogLevel.Trace) {
            return "TRACE";
        }
        return "UNDEF";
    }

    public static int toInteger(LogLevel level) {
        if (level == LogLevel.Fatal) {
            return 1;
        }
        if (level == LogLevel.Error) {
            return 2;
        }
        if (level == LogLevel.Warn) {
            return 3;
        }
        if (level == LogLevel.Info) {
            return 4;
        }
        if (level == LogLevel.Debug) {
            return 5;
        }
        if (level == LogLevel.Trace) {
            return 6;
        }
        return 0;
    }
}

