/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.log;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.observability.log.LogLevel;
import org.pipservices4.observability.log.LogLevelConverter;
import org.pipservices4.observability.log.Logger;

public class ConsoleLogger
extends Logger {
    @Override
    protected void write(LogLevel level, IContext context, Exception error, String message) {
        if (LogLevelConverter.toInteger(this.getLevel()) < LogLevelConverter.toInteger(level)) {
            return;
        }
        StringBuilder build = new StringBuilder();
        build.append('[');
        build.append(context != null ? ContextResolver.getTraceId(context) : "---");
        build.append(':');
        build.append(LogLevelConverter.toString(level));
        build.append(':');
        build.append(ZonedDateTime.now(ZoneId.of("Z")).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        build.append("] ");
        build.append(message);
        if (error != null) {
            if (message.isEmpty()) {
                build.append("Error: ");
            } else {
                build.append(": ");
            }
            build.append(this.composeError(error));
        }
        String output = build.toString();
        if (level == LogLevel.Fatal || level == LogLevel.Error || level == LogLevel.Warn) {
            System.err.println(output);
        } else {
            System.out.println(output);
        }
    }
}

