/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.log;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.log.ILogger;
import org.pipservices4.observability.log.LogLevel;
import org.pipservices4.observability.log.Logger;

public class CompositeLogger
extends Logger {
    private final List<ILogger> _loggers = new ArrayList<ILogger>();

    public CompositeLogger() {
    }

    public CompositeLogger(IReferences references) throws ReferenceException {
        if (references != null) {
            this.setReferences(references);
        }
    }

    @Override
    public void setReferences(IReferences references) {
        List<Object> loggers = references.getOptional(new Descriptor(null, "logger", null, null, null));
        for (Object logger : loggers) {
            if (!(logger instanceof ILogger) || logger == this) continue;
            this._loggers.add((ILogger)logger);
        }
    }

    @Override
    protected void write(LogLevel level, IContext context, Exception error, String message) {
        for (ILogger logger : this._loggers) {
            logger.log(level, context, error, message, new Object[0]);
        }
    }
}

