/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.logic.lock;

import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConflictException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.logic.lock.ILock;

public abstract class Lock
implements ILock,
IReconfigurable {
    private int _retryTimeout = 100;

    @Override
    public void configure(ConfigParams config) {
        this._retryTimeout = config.getAsIntegerWithDefault("options.retry_timeout", this._retryTimeout);
    }

    @Override
    public abstract boolean tryAcquireLock(IContext var1, String var2, int var3);

    @Override
    public void acquireLock(IContext context, String key, int ttl, long timeout) throws InterruptedException, ApplicationException {
        long retryTime = System.currentTimeMillis() + timeout;
        boolean ok = this.tryAcquireLock(context, key, ttl);
        if (ok) {
            return;
        }
        while (!ok) {
            Thread.sleep(this._retryTimeout);
            long now = System.currentTimeMillis();
            if (now > retryTime) {
                throw new ConflictException(context != null ? ContextResolver.getTraceId(context) : null, "LOCK_TIMEOUT", "Acquiring lock " + key + " failed on timeout").withDetails("key", key);
            }
            ok = this.tryAcquireLock(context, key, ttl);
        }
    }

    @Override
    public abstract void releaseLock(IContext var1, String var2);
}

