/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import com.sun.net.httpserver.HttpServer;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ConnectionException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.DependencyResolver;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.HttpConnectionResolver;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationException;
import org.pipservices4.http.controllers.AuthorizeFunction;
import org.pipservices4.http.controllers.HttpResponseSender;
import org.pipservices4.http.controllers.IRegisterable;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;

public class HttpEndpoint
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("connection.protocol", "http", "connection.host", "0.0.0.0", "connection.port", 3000, "credential.ssl_key_file", null, "credential.ssl_crt_file", null, "credential.ssl_ca_file", null, "options.maintenance_enabled", false, "options.request_max_size", 0x100000, "options.connect_timeout", 60000, "options.connect_timeout", 60000, "options.debug", true);
    protected HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected DependencyResolver _dependencyResolver = new DependencyResolver(_defaultConfig);
    private String _url;
    private HttpServer _server;
    private ResourceConfig _resources;
    private final List<IRegisterable> _registrations = new ArrayList<IRegisterable>();
    private boolean _protocolUpgradeEnabled = false;
    private boolean _maintenanceEnabled = false;
    private long _fileMaxSize = 0xC800000L;
    private List<String> _allowedHeaders = List.of("trace_id");
    private List<String> _allowedOrigins = new ArrayList<String>();

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        String[] origins;
        String[] headers;
        config = config.setDefaults(_defaultConfig);
        this._connectionResolver.configure(config);
        this._maintenanceEnabled = config.getAsBooleanWithDefault("options.maintenance_enabled", this._maintenanceEnabled);
        this._fileMaxSize = config.getAsLongWithDefault("options.file_max_size", this._fileMaxSize);
        this._protocolUpgradeEnabled = config.getAsBooleanWithDefault("options.protocol_upgrade_enabled", this._protocolUpgradeEnabled);
        for (String header : headers = config.getAsStringWithDefault("cors_headers", "").split(",")) {
            if ((header = header.trim()).isEmpty()) continue;
            String finalHeader = header;
            this._allowedHeaders = this._allowedHeaders.stream().filter(h -> !h.equals(finalHeader)).collect(Collectors.toList());
            this._allowedHeaders.add(finalHeader);
        }
        for (String origin : origins = config.getAsStringWithDefault("cors_origins", "").split(",")) {
            if ((origin = origin.trim()).isEmpty()) continue;
            String finalOrigin = origin;
            this._allowedOrigins = this._allowedOrigins.stream().filter(h -> !h.equals(finalOrigin)).collect(Collectors.toList());
            this._allowedOrigins.add(finalOrigin);
        }
        this._dependencyResolver.configure(config);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    protected CounterTiming Instrument(IContext context, String name) {
        this._logger.trace(context, "Executing {0} method", name);
        return this._counters.beginTiming(name + ".exec_time");
    }

    public HttpServer getServer() {
        return this._server;
    }

    @Override
    public boolean isOpen() {
        return this._server != null;
    }

    @Override
    public void open(IContext context) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        SSLContext sslContext = null;
        ConnectionParams connection = this._connectionResolver.resolve(context);
        String protocol = connection.getProtocolWithDefault("http");
        String host = connection.getHost();
        int port = connection.getPort();
        URI uri = UriBuilder.fromUri(protocol + "://" + host).port(port).path("/").build(new Object[0]);
        this._url = uri.toString();
        try {
            this._resources = new ResourceConfig();
            if (Objects.equals(connection.getAsStringWithDefault("protocol", "http"), "https")) {
                String sslKeyFile = connection.getAsNullableString("ssl_key_file");
                String privateKey = this.readCertFile(sslKeyFile);
                String sslCrtFile = connection.getAsNullableString("ssl_crt_file");
                ArrayList<String> ca = new ArrayList<String>();
                String sslCaFile = connection.getAsNullableString("ssl_ca_file");
                if (sslCaFile != null) {
                    String caText = this.readCertFile(sslCaFile);
                    while (caText != null && !caText.trim().isEmpty()) {
                        int crtIndex = caText.lastIndexOf("-----BEGIN CERTIFICATE-----");
                        if (crtIndex <= -1) continue;
                        ca.add(caText.substring(crtIndex));
                        caText = caText.substring(0, crtIndex);
                    }
                }
                sslContext = SSLContext.getInstance("SSL");
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null);
                FileInputStream fis = new FileInputStream(sslCrtFile);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate cert = cf.generateCertificate(fis);
                keyStore.setCertificateEntry("ssl", cert);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, privateKey.toCharArray());
                try {
                    sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
                }
                catch (KeyManagementException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.performRegistrations();
            this._server = sslContext != null ? JdkHttpServerFactory.createHttpServer(uri, this._resources, sslContext) : JdkHttpServerFactory.createHttpServer(uri, this._resources);
            this._logger.info(context, "Opened REST service at %s", this._url);
        }
        catch (Exception ex) {
            this._server = null;
            throw new ConnectionException(context != null ? ContextResolver.getTraceId(context) : null, "CANNOT_CONNECT", "Opening HTTP endpoint failed").wrap(ex).withDetails("url", this._url);
        }
    }

    private String readCertFile(String path) throws IOException {
        if (path == null) {
            return null;
        }
        try (FileInputStream fis = new FileInputStream(path);){
            String string = new String(fis.readAllBytes(), Charset.defaultCharset());
            return string;
        }
    }

    @Override
    public void close(IContext context) {
        if (this._server != null) {
            try {
                this._server.stop(0);
                this._logger.info(context, "Closed HTTP endpoint at %s", this._url);
            }
            catch (Exception ex) {
                this._logger.warn(context, "Failed while closing HTTP endpoint: %s", ex);
            }
            this._server = null;
            this._resources = null;
            this._url = null;
        }
    }

    private void performRegistrations() throws ReferenceException {
        for (IRegisterable registration : this._registrations) {
            registration.register();
        }
    }

    public void register(IRegisterable registration) {
        this._registrations.add(registration);
    }

    public void unregister(IRegisterable registration) {
        this._registrations.remove(registration);
    }

    public String getTraceId(ContainerRequestContext req) {
        String traceId;
        String string = traceId = this.getQueryParameter(req, "trace_id") != null ? this.getQueryParameter(req, "trace_id") : this.getQueryParameter(req, "correlation_id");
        if (traceId == null || traceId.isEmpty()) {
            traceId = req.getHeaderString("trace_id") != null && !req.getHeaderString("trace_id").isEmpty() ? req.getHeaderString("trace_id") : req.getHeaderString("correlation_id");
        }
        return traceId;
    }

    protected String getQueryParameter(ContainerRequestContext request, String name) {
        String value = null;
        name = URLEncoder.encode(name, StandardCharsets.UTF_8);
        if (request.getUriInfo().getQueryParameters().containsKey(name)) {
            value = request.getUriInfo().getQueryParameters().getFirst(name);
            value = value != null ? URLDecoder.decode(value, StandardCharsets.UTF_8) : null;
        }
        return value;
    }

    public void registerRoute(String method, String route, Inflector<ContainerRequestContext, Response> action) {
        if (route.charAt(0) == '/') {
            route = route.substring(1);
        }
        Resource.Builder builder = Resource.builder().addChildResource(route);
        method = method.toUpperCase();
        builder.addMethod(method).handledBy(action);
        Resource resource = builder.build();
        if (this._resources != null) {
            this._resources.registerResources(resource);
        }
    }

    public void registerRoute(String method, String route, final Schema schema, final Inflector<ContainerRequestContext, Response> action) {
        Inflector<ContainerRequestContext, Response> actionCurl = new Inflector<ContainerRequestContext, Response>(){

            @Override
            public Response apply(ContainerRequestContext req) {
                if (schema != null) {
                    Map<?, ?> params = HttpEndpoint.this.getAllParams(req);
                    String traceId = HttpEndpoint.this.getTraceId(req);
                    try {
                        schema.validateAndThrowException(traceId, params, false);
                    }
                    catch (ValidationException err) {
                        return HttpResponseSender.sendError(err);
                    }
                }
                return (Response)action.apply(req);
            }
        };
        this.registerRoute(method, route, actionCurl);
    }

    public void registerRouteWithAuth(String method, String route, Schema schema, AuthorizeFunction<ContainerRequestContext, Inflector<ContainerRequestContext, Response>, Response> authorize, Inflector<ContainerRequestContext, Response> action) {
        if (authorize != null) {
            this.registerRoute(method, route, schema, req -> (Response)authorize.apply((ContainerRequestContext)req, action));
        } else {
            this.registerRoute(method, route, schema, action);
        }
    }

    private static String fixRoute(String route) {
        if (route != null && !((String)route).isEmpty() && !((String)route).startsWith("/")) {
            route = "/" + (String)route;
        }
        return route;
    }

    public void registerInterceptor(String route, Function<ContainerRequestContext, ?> action) {
        route = HttpEndpoint.fixRoute(route);
        this._resources.register(new InterceptorRegister(action, route));
    }

    private Map<?, ?> getAllParams(ContainerRequestContext req) {
        Map<String, Object> body;
        MultivaluedMap<String, String> pathParams = req.getUriInfo().getPathParameters();
        MultivaluedMap<String, String> queryParams = req.getUriInfo().getQueryParameters();
        try {
            byte[] bodyBytes = req.getEntityStream().readAllBytes();
            String json = new String(bodyBytes, StandardCharsets.UTF_8);
            body = JsonConverter.toMap(json);
            req.setEntityStream(new ByteArrayInputStream(bodyBytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("body", body);
        pathParams.forEach((k, v) -> {
            if (k != null && !k.isEmpty() && v != null && !v.stream().findFirst().orElse("").isEmpty()) {
                params.put((String)k, (Map<String, Object>)v.stream().findFirst().get());
            }
        });
        queryParams.forEach((k, v) -> {
            if (k != null && !k.isEmpty() && v != null && !v.stream().findFirst().orElse("").isEmpty()) {
                params.put((String)k, (Map<String, Object>)v.stream().findFirst().get());
            }
        });
        return params;
    }

    @Provider
    private static class InterceptorRegister
    implements ContainerRequestFilter {
        private final Function<ContainerRequestContext, ?> _interceptor;
        private final String _route;

        public InterceptorRegister(Function<ContainerRequestContext, ?> interceptor, String route) {
            this._interceptor = interceptor;
            this._route = route;
        }

        @Override
        public void filter(ContainerRequestContext ctx) throws IOException {
            Pattern stringPattern = Pattern.compile(this._route);
            Matcher matcher = stringPattern.matcher(HttpEndpoint.fixRoute(ctx.getUriInfo().getPath(true)));
            ArrayList<String> resMatch = new ArrayList<String>();
            while (matcher.find()) {
                resMatch.add(matcher.group());
            }
            if (!resMatch.isEmpty() && this._route != null && !this._route.isEmpty()) {
                this._interceptor.apply(ctx);
            }
        }
    }
}

