/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.glassfish.jersey.process.Inflector;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.http.controllers.CommandableSwaggerDocument;
import org.pipservices4.http.controllers.RestController;
import org.pipservices4.rpc.commands.CommandSet;
import org.pipservices4.rpc.commands.ICommand;
import org.pipservices4.rpc.commands.ICommandable;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class CommandableHttpController
extends RestController {
    protected CommandSet _commandSet;
    protected boolean _swaggerAuto = true;

    public CommandableHttpController(String baseRoute) {
        this._baseRoute = baseRoute;
        this._dependencyResolver.put("service", "none");
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._swaggerAuto = config.getAsBooleanWithDefault("swagger.auto", this._swaggerAuto);
    }

    @Override
    public void register() throws ReferenceException {
        ICommandable service = (ICommandable)this._dependencyResolver.getOneRequired("service");
        this._commandSet = service.getCommandSet();
        List<ICommand> commands = this._commandSet.getCommands();
        for (final ICommand command : commands) {
            this.registerRoute("POST", command.getName(), new Inflector<ContainerRequestContext, Response>(){

                @Override
                public Response apply(ContainerRequestContext request) {
                    return CommandableHttpController.this.executeCommand(command, request);
                }
            });
        }
        if (this._swaggerAuto) {
            ConfigParams swaggerConfig = this._config.getSection("swagger");
            CommandableSwaggerDocument doc = new CommandableSwaggerDocument(this._baseRoute, swaggerConfig, commands);
            this.registerOpenApiSpec(doc.toString());
        }
    }

    private Response executeCommand(ICommand command, ContainerRequestContext request) {
        String traceId = this.getTraceId(request);
        Context context = traceId != null ? Context.fromTraceId(traceId) : null;
        InstrumentTiming timing = this.instrument(context, this._baseRoute + "." + command.getName());
        try {
            String json = this.getBodyAsString(request);
            Parameters parameters = json == null ? new Parameters() : Parameters.fromJson(json);
            Object result = command.execute(context, parameters);
            timing.endTiming();
            return this.sendResult(result);
        }
        catch (Exception ex) {
            timing.endFailure(ex);
            return this.sendError(ex);
        }
    }
}

