/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.auth;

import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.List;
import org.pipservices4.http.auth.UserPrincipal;

public class PipSecurityContext
implements SecurityContext {
    private UserPrincipal _user;
    private List<String> _roles;
    private String _authType;
    private boolean _isSecure = false;

    public PipSecurityContext(UserPrincipal user, List<String> roles) {
        this._user = user;
        this._roles = roles;
        this._authType = "BASIC";
    }

    public PipSecurityContext(UserPrincipal user, List<String> roles, String authType, boolean isSecure) {
        this._user = user;
        this._roles = roles;
        this._authType = authType;
        this._isSecure = isSecure;
    }

    @Override
    public Principal getUserPrincipal() {
        return this._user;
    }

    @Override
    public boolean isUserInRole(String role) {
        return !this._roles.isEmpty() && this._roles.contains(role);
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    @Override
    public String getAuthenticationScheme() {
        return this._authType;
    }
}

