/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.auth;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.glassfish.jersey.process.Inflector;
import org.pipservices4.commons.errors.UnauthorizedException;
import org.pipservices4.http.controllers.AuthorizeFunction;
import org.pipservices4.http.controllers.HttpResponseSender;

public class OwnerAuthorizer {
    public AuthorizeFunction<ContainerRequestContext, Inflector<ContainerRequestContext, Response>, Response> owner(String idParam) {
        return (req, nextFunc) -> {
            if (req.getSecurityContext().getUserPrincipal() == null) {
                return HttpResponseSender.sendError(new UnauthorizedException(null, "NOT_SIGNED", "User must be signed in to perform this operation").withStatus(401));
            }
            String userId = this.getQueryParameter((ContainerRequestContext)req, idParam);
            if (req.getProperty("user_id") != userId) {
                return HttpResponseSender.sendError(new UnauthorizedException(null, "FORBIDDEN", "Only data owner can perform this operation").withStatus(403));
            }
            return (Response)nextFunc.apply(req);
        };
    }

    public AuthorizeFunction<ContainerRequestContext, Inflector<ContainerRequestContext, Response>, Response> ownerOrAdmin(String idParam) {
        return (req, nextFunc) -> {
            if (req.getSecurityContext().getUserPrincipal() == null) {
                return HttpResponseSender.sendError(new UnauthorizedException(null, "NOT_SIGNED", "User must be signed in to perform this operation").withStatus(401));
            }
            String userId = this.getQueryParameter((ContainerRequestContext)req, idParam);
            boolean isAdmin = req.getSecurityContext().isUserInRole("admin");
            if (req.getProperty("user_id") != userId && !isAdmin) {
                return HttpResponseSender.sendError(new UnauthorizedException(null, "FORBIDDEN", "Only data owner can perform this operation").withStatus(403));
            }
            return (Response)nextFunc.apply(req);
        };
    }

    private String getQueryParameter(ContainerRequestContext request, String name) {
        String value = null;
        name = URLEncoder.encode(name, StandardCharsets.UTF_8);
        if (request.getUriInfo().getQueryParameters().containsKey(name)) {
            value = request.getUriInfo().getQueryParameters().getFirst(name);
            value = value != null ? URLDecoder.decode(value, StandardCharsets.UTF_8) : null;
        }
        return value;
    }
}

