/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.tokenizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.io.StringScanner;
import org.pipservices4.expressions.tokenizers.ICommentState;
import org.pipservices4.expressions.tokenizers.INumberState;
import org.pipservices4.expressions.tokenizers.IQuoteState;
import org.pipservices4.expressions.tokenizers.ISymbolState;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.ITokenizerState;
import org.pipservices4.expressions.tokenizers.IWhitespaceState;
import org.pipservices4.expressions.tokenizers.IWordState;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.utilities.CharReferenceMap;
import org.pipservices4.expressions.tokenizers.utilities.CharValidator;

public abstract class AbstractTokenizer
implements ITokenizer {
    private final CharReferenceMap<ITokenizerState> _map = new CharReferenceMap();
    private boolean skipUnknown = false;
    private boolean skipWhitespaces = false;
    private boolean skipComments = false;
    private boolean skipEof = false;
    private boolean mergeWhitespaces = false;
    private boolean unifyNumbers = false;
    private boolean decodeStrings = false;
    private ICommentState commentState;
    private INumberState numberState;
    private IQuoteState quoteState;
    private ISymbolState symbolState;
    private IWhitespaceState whitespaceState;
    private IWordState wordState;
    protected IScanner _scanner;
    protected Token _nextToken;
    protected TokenType _lastTokenType = TokenType.Unknown;

    @Override
    public Boolean getSkipUnknown() {
        return this.skipUnknown;
    }

    @Override
    public void setSkipUnknown(boolean value) {
        this.skipUnknown = value;
    }

    @Override
    public Boolean getSkipWhitespaces() {
        return this.skipWhitespaces;
    }

    @Override
    public void setSkipWhitespaces(boolean value) {
        this.skipWhitespaces = value;
    }

    @Override
    public Boolean getSkipComments() {
        return this.skipComments;
    }

    @Override
    public void setSkipComments(boolean value) {
        this.skipComments = value;
    }

    @Override
    public Boolean getSkipEof() {
        return this.skipEof;
    }

    @Override
    public void setSkipEof(boolean value) {
        this.skipEof = value;
    }

    @Override
    public Boolean getMergeWhitespaces() {
        return this.mergeWhitespaces;
    }

    @Override
    public void setMergeWhitespaces(boolean value) {
        this.mergeWhitespaces = value;
    }

    @Override
    public Boolean getUnifyNumbers() {
        return this.unifyNumbers;
    }

    @Override
    public void setUnifyNumbers(boolean value) {
        this.unifyNumbers = value;
    }

    @Override
    public Boolean getDecodeStrings() {
        return this.decodeStrings;
    }

    @Override
    public void setDecodeStrings(boolean value) {
        this.decodeStrings = value;
    }

    @Override
    public ICommentState getCommentState() {
        return this.commentState;
    }

    @Override
    public void setCommentState(ICommentState value) {
        this.commentState = value;
    }

    @Override
    public INumberState getNumberState() {
        return this.numberState;
    }

    @Override
    public void setNumberState(INumberState value) {
        this.numberState = value;
    }

    @Override
    public IQuoteState getQuoteState() {
        return this.quoteState;
    }

    @Override
    public void setQuoteState(IQuoteState value) {
        this.quoteState = value;
    }

    @Override
    public ISymbolState getSymbolState() {
        return this.symbolState;
    }

    @Override
    public void setSymbolState(ISymbolState value) {
        this.symbolState = value;
    }

    @Override
    public IWhitespaceState getWhitespaceState() {
        return this.whitespaceState;
    }

    @Override
    public void setWhitespaceState(IWhitespaceState value) {
        this.whitespaceState = value;
    }

    @Override
    public IWordState getWordState() {
        return this.wordState;
    }

    @Override
    public void setWordState(IWordState value) {
        this.wordState = value;
    }

    @Override
    public IScanner getScanner() {
        return this._scanner;
    }

    @Override
    public void setScanner(IScanner value) {
        this._scanner = value;
        this._nextToken = null;
        this._lastTokenType = TokenType.Unknown;
    }

    public ITokenizerState getCharacterState(int symbol) {
        return this._map.lookup(symbol);
    }

    public void setCharacterState(int fromSymbol, int toSymbol, ITokenizerState state) throws Exception {
        this._map.addInterval(fromSymbol, toSymbol, state);
    }

    public void clearCharacterStates() {
        this._map.clear();
    }

    @Override
    public Boolean hasNextToken() throws Exception {
        this._nextToken = this._nextToken == null ? this.readNextToken() : this._nextToken;
        return this._nextToken != null;
    }

    @Override
    public Token nextToken() throws Exception {
        Token token = this._nextToken == null ? this.readNextToken() : this._nextToken;
        this._nextToken = null;
        return token;
    }

    protected Token readNextToken() throws Exception {
        Token token;
        int column;
        int line;
        block11: {
            if (this._scanner == null) {
                return null;
            }
            line = this._scanner.peekLine();
            column = this._scanner.peekColumn();
            token = null;
            while (true) {
                int nextChar;
                if (CharValidator.isEof(nextChar = this._scanner.peek())) {
                    token = null;
                    break block11;
                }
                ITokenizerState state = this.getCharacterState(nextChar);
                if (state != null) {
                    token = state.nextToken(this._scanner, this);
                }
                if (token == null || Objects.equals(token.getValue(), "")) {
                    token = new Token(TokenType.Unknown, String.valueOf((char)this._scanner.read()), line, column);
                }
                if (token.getType() == TokenType.Unknown && this.skipUnknown) {
                    this._lastTokenType = token.getType();
                    continue;
                }
                if (state instanceof IQuoteState && this.decodeStrings) {
                    token = new Token(token.getType(), this.quoteState.decodeString(token.getValue(), nextChar), line, column);
                }
                if (token.getType() == TokenType.Comment && this.skipComments) {
                    this._lastTokenType = token.getType();
                    continue;
                }
                if (token.getType() != TokenType.Whitespace || this._lastTokenType != TokenType.Whitespace || !this.skipWhitespaces) break;
                this._lastTokenType = token.getType();
            }
            if (token.getType() == TokenType.Whitespace && this.mergeWhitespaces) {
                token = new Token(TokenType.Whitespace, " ", line, column);
            }
            if (this.unifyNumbers && (token.getType() == TokenType.Integer || token.getType() == TokenType.Float || token.getType() == TokenType.HexDecimal)) {
                token = new Token(TokenType.Number, token.getValue(), line, column);
            }
        }
        if (token == null && this._lastTokenType != TokenType.Eof && !this.skipEof) {
            token = new Token(TokenType.Eof, null, line, column);
        }
        this._lastTokenType = token != null ? token.getType() : TokenType.Eof;
        return token;
    }

    @Override
    public List<Token> tokenizeStream(IScanner scanner) throws Exception {
        this._scanner = scanner;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        Token token = this.nextToken();
        while (token != null) {
            tokenList.add(token);
            token = this.nextToken();
        }
        return tokenList;
    }

    @Override
    public List<Token> tokenizeBuffer(String buffer) throws Exception {
        StringScanner scanner = new StringScanner(buffer);
        return this.tokenizeStream(scanner);
    }

    @Override
    public List<String> tokenizeStreamToStrings(IScanner scanner) throws Exception {
        this._scanner = scanner;
        ArrayList<String> stringList = new ArrayList<String>();
        Token token = this.nextToken();
        while (token != null) {
            stringList.add(token.getValue());
            token = this.nextToken();
        }
        return stringList;
    }

    @Override
    public List<String> tokenizeBufferToStrings(String buffer) throws Exception {
        StringScanner scanner = new StringScanner(buffer);
        return this.tokenizeStreamToStrings(scanner);
    }
}

