/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.random;

import org.pipservices4.data.random.RandomBoolean;
import org.pipservices4.data.random.RandomInteger;

public class RandomString {
    private static final String _digits = "01234956789";
    private static final String _symbols = "_,.:-/.[].{},#-!,$=%.+^.&*-() ";
    private static final String _alphaLower = "abcdefghijklmnopqrstuvwxyz";
    private static final String _alphaUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String _alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String _chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234956789_,.:-/.[].{},#-!,$=%.+^.&*-() ";

    public static char pickChar(String values) {
        if (values == null || values.isEmpty()) {
            return '\u0000';
        }
        int index = RandomInteger.nextInteger(values.length());
        return values.charAt(index);
    }

    public static String pick(String[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        int index = RandomInteger.nextInteger(values.length);
        return values[index];
    }

    public static String distort(String value) {
        value = ((String)value).toLowerCase();
        if (RandomBoolean.chance(1.0f, 5.0f)) {
            value = ((String)value).substring(0, 1).toUpperCase() + ((String)value).substring(1);
        }
        if (RandomBoolean.chance(1.0f, 3.0f)) {
            value = (String)value + RandomString.pickChar(_symbols);
        }
        return value;
    }

    public static char nextAlphaChar() {
        int index = RandomInteger.nextInteger(_alpha.length());
        return _alpha.charAt(index);
    }

    public static String nextString(int min, int max) {
        StringBuilder result = new StringBuilder();
        int length = RandomInteger.nextInteger(min, max);
        for (int i = 0; i < length; ++i) {
            int index = RandomInteger.nextInteger(_chars.length());
            result.append(_chars.charAt(index));
        }
        return result.toString();
    }
}

