/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.IDiscovery;

public class MemoryDiscovery
implements IDiscovery,
IReconfigurable {
    private final List<DiscoveryItem> _items = new ArrayList<DiscoveryItem>();
    private final Object _lock = new Object();

    public MemoryDiscovery() {
    }

    public MemoryDiscovery(ConfigParams config) {
        if (config != null) {
            this.configure(config);
        }
    }

    @Override
    public void configure(ConfigParams config) {
        this.readConnections(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConnections(ConfigParams config) {
        Object object = this._lock;
        synchronized (object) {
            this._items.clear();
            ConfigParams connections = config.getSection("connections");
            if (!connections.isEmpty()) {
                List<String> connectionSections = connections.getSectionNames();
                for (String key : connectionSections) {
                    ConfigParams value = connections.getSection(key);
                    DiscoveryItem item = new DiscoveryItem();
                    item.key = key;
                    item.connection = new ConnectionParams((Map<?, ?>)value);
                    this._items.add(item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IContext context, String key, ConnectionParams connection) {
        Object object = this._lock;
        synchronized (object) {
            DiscoveryItem item = new DiscoveryItem();
            item.key = key;
            item.connection = connection;
            this._items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionParams resolveOne(IContext context, String key) {
        ConnectionParams connection = null;
        Object object = this._lock;
        synchronized (object) {
            for (DiscoveryItem item : this._items) {
                if (!Objects.equals(item.key, key) || item.connection == null) continue;
                connection = item.connection;
                break;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectionParams> resolveAll(IContext context, String key) {
        ArrayList<ConnectionParams> connections = new ArrayList<ConnectionParams>();
        Object object = this._lock;
        synchronized (object) {
            for (DiscoveryItem item : this._items) {
                if (!Objects.equals(item.key, key) || item.connection == null) continue;
                connections.add(item.connection);
            }
        }
        return connections;
    }

    private static class DiscoveryItem {
        public String key;
        public ConnectionParams connection;

        private DiscoveryItem() {
        }
    }
}

