/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.refer;

import org.pipservices4.commons.errors.ConfigException;

public class Descriptor {
    private final String _group;
    private final String _type;
    private final String _kind;
    private final String _name;
    private final String _version;

    public Descriptor(String group, String type, String kind, String name, String version) {
        if ("*".equals(group)) {
            group = null;
        }
        if ("*".equals(type)) {
            type = null;
        }
        if ("*".equals(kind)) {
            kind = null;
        }
        if ("*".equals(name)) {
            name = null;
        }
        if ("*".equals(version)) {
            version = null;
        }
        this._group = group;
        this._type = type;
        this._kind = kind;
        this._name = name;
        this._version = version;
    }

    public String getGroup() {
        return this._group;
    }

    public String getType() {
        return this._type;
    }

    public String getKind() {
        return this._kind;
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    private boolean matchField(String field1, String field2) {
        return field1 == null || field2 == null || field1.equals(field2);
    }

    public boolean match(Descriptor descriptor) {
        return this.matchField(this._group, descriptor.getGroup()) && this.matchField(this._type, descriptor.getType()) && this.matchField(this._kind, descriptor.getKind()) && this.matchField(this._name, descriptor.getName()) && this.matchField(this._version, descriptor.getVersion());
    }

    private boolean exactMatchField(String field1, String field2) {
        if (field1 == null && field2 == null) {
            return true;
        }
        if (field1 == null || field2 == null) {
            return false;
        }
        return field1.equals(field2);
    }

    public boolean exactMatch(Descriptor descriptor) {
        return this.exactMatchField(this._group, descriptor.getGroup()) && this.exactMatchField(this._type, descriptor.getType()) && this.exactMatchField(this._kind, descriptor.getKind()) && this.exactMatchField(this._name, descriptor.getName()) && this.exactMatchField(this._version, descriptor.getVersion());
    }

    public boolean isComplete() {
        return this._group != null && this._type != null && this._kind != null && this._name != null && this._version != null;
    }

    public boolean equals(Object value) {
        if (value instanceof Descriptor) {
            return this.match((Descriptor)value);
        }
        return false;
    }

    public String toString() {
        return (this._group != null ? this._group : "*") + ":" + (this._type != null ? this._type : "*") + ":" + (this._kind != null ? this._kind : "*") + ":" + (this._name != null ? this._name : "*") + ":" + (this._version != null ? this._version : "*");
    }

    public static Descriptor fromString(String value) throws ConfigException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] tokens = value.split(":");
        if (tokens.length != 5) {
            throw (ConfigException)new ConfigException(null, "BAD_DESCRIPTOR", "Descriptor " + value + " is in wrong format").withDetails("descriptor", value);
        }
        return new Descriptor(tokens[0].trim(), tokens[1].trim(), tokens[2].trim(), tokens[3].trim(), tokens[4].trim());
    }
}

