/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.exec;

import java.util.Timer;
import java.util.TimerTask;
import org.pipservices4.components.context.Context;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.INotifiable;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.run.IClosable;

public class FixedRateTimer
implements IClosable {
    private INotifiable _task;
    private long _delay;
    private long _interval;
    private final Timer _timer = new Timer("pip-commons-timer", true);
    private boolean _started = false;
    private final Object _lock = new Object();

    public FixedRateTimer() {
    }

    public FixedRateTimer(INotifiable task, long interval, long delay) {
        this._task = task;
        this._interval = interval;
        this._delay = delay;
    }

    public INotifiable getTask() {
        return this._task;
    }

    public void setTask(INotifiable task) {
        this._task = task;
    }

    public long getDelay() {
        return this._delay;
    }

    public void setDelay(long delay) {
        this._delay = delay;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public boolean isStarted() {
        return this._started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            this._timer.purge();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (FixedRateTimer.this._task != null) {
                            FixedRateTimer.this._task.notify(Context.fromTraceId("pip-commons-timer"), new Parameters());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this._timer.scheduleAtFixedRate(task, this._delay, this._interval);
            this._started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this._lock;
        synchronized (object) {
            this._timer.purge();
            this._started = false;
        }
    }

    @Override
    public void close(IContext context) {
        this.stop();
    }
}

