/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;

public class BooleanConverter {
    public static Boolean toNullableBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof Duration) {
            if (((Duration)value).toMillis() > 0L) {
                return true;
            }
            return false;
        }
        String strValue = value.toString().toLowerCase();
        if (strValue.equals("1") || strValue.equals("true") || strValue.equals("t") || strValue.equals("yes") || strValue.equals("y")) {
            return true;
        }
        if (strValue.equals("0") || strValue.equals("false") || strValue.equals("f") || strValue.equals("no") || strValue.equals("n")) {
            return false;
        }
        return null;
    }

    public static boolean toBoolean(Object value) {
        return BooleanConverter.toBooleanWithDefault(value, false);
    }

    public static boolean toBooleanWithDefault(Object value, boolean defaultValue) {
        Boolean result = BooleanConverter.toNullableBoolean(value);
        return result != null ? result : defaultValue;
    }
}

