/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.grpc.clients;

import java.util.Map;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.errors.ApplicationExceptionFactory;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.grpc.clients.GrpcClient;
import org.pipservices4.grpc.commandable.CommandableGrpc;
import org.pipservices4.grpc.commandable.ErrorDescription;
import org.pipservices4.grpc.commandable.InvokeReply;
import org.pipservices4.grpc.commandable.InvokeRequest;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class CommandableGrpcClient
extends GrpcClient {
    protected String _name;

    public CommandableGrpcClient(String name) {
        super(CommandableGrpc.getServiceDescriptor());
        this._name = name;
    }

    protected <T> T callCommand(Class<T> returnType, String name, IContext context, Object params) {
        String method = this._name + "." + name;
        InstrumentTiming timing = this.instrument(context, method);
        try {
            InvokeReply response;
            InvokeRequest.Builder request = InvokeRequest.newBuilder().setMethod(method).setArgsEmpty(params == null || params instanceof Map && ((Map)params).isEmpty());
            if (context != null) {
                request.setTraceId(ContextResolver.getTraceId((IContext)context));
            }
            if (params != null) {
                request.setArgsJson(JsonConverter.toJson((Object)params));
            }
            if (!(response = (InvokeReply)this.call("invoke", context, request.build())).getError().getMessage().equals("")) {
                throw ApplicationExceptionFactory.create((org.pipservices4.commons.errors.ErrorDescription)this.convertErrorDescription(response.getError()));
            }
            if (response.getResultEmpty() || response.getResultJson().equals("") || response.getResultJson().equals("{}")) {
                T t = null;
                return t;
            }
            Object object = JsonConverter.fromJson(returnType, (String)response.getResultJson());
            return (T)object;
        }
        catch (Exception ex) {
            timing.endFailure(ex);
            throw new RuntimeException(ex);
        }
        finally {
            timing.endSuccess();
        }
    }

    private org.pipservices4.commons.errors.ErrorDescription convertErrorDescription(ErrorDescription ex) {
        org.pipservices4.commons.errors.ErrorDescription err = new org.pipservices4.commons.errors.ErrorDescription();
        err.setStatus(ex.getStatus());
        err.setCause(ex.getCause());
        err.setTraceId(ex.getTraceId());
        err.setMessage(ex.getMessage());
        err.setCause(ex.getCause());
        err.setStackTrace(ex.getStackTrace());
        err.setCategory(ex.getCategory());
        err.setCode(ex.getCode());
        return err;
    }
}

