#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

Write-Host "Updating component.json template variables..."

# Get component metadata
$componentRaw = Get-Content -Path "$PSScriptRoot/../../../component.json"
$component = $componentRaw | ConvertFrom-Json

# Replace template variables in component metadata
$componentRaw | Select-String -Pattern "<\w+>" -AllMatches | foreach {$_.matches.value} | Get-Unique | 
    foreach {
        $templateVar = $_ -replace "<" -replace ">"
        $componentRaw = $componentRaw -replace "<$templateVar>", $component.$templateVar
    }

# Update component after template variables replacement
$component = $componentRaw | ConvertFrom-Json
foreach ($artifact in $component.artifacts) {
    if ($artifact.type -eq "pypi" -or $artifact.type -eq "dart") {
        $artifact.name = $artifact.name -replace "-", "_"
    } elseif ($artifact.type -eq "docker" -and $artifact.name[0] -eq "-") {
        $artifact.name = $artifact.name.Substring(1)
    }
}

# Save updated component metadata
ConvertTo-Json $component | Set-Content -Path "$PSScriptRoot/../../../component.json"
