#!/usr/bin/env pwsh

param
(
    [Parameter(Mandatory = $true, Position = 0)]
    [string] $Product
)

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Get all product pods
$productDeployments = kubectl get deployments -l product=$Product --no-headers -o custom-columns=":metadata.name"

# Update images to baseline
foreach ($deployment in $productDeployments) {
    $oldImage = kubectl get deployments $deployment -o jsonpath="{..image}"
    $newImage = "$($oldImage.Split(":")[0]):$($component.baseline)"
    Write-Host "Updating '$oldImage' to '$newImage'..."
    kubectl set image "deployment/$deployment" "$deployment=$newImage"
    # Check for success
    if ($LASTEXITCODE -ne 0) {
        Write-Error "Can't update '$deployment' deployment."
    }
    # Add sleep interval to prevent timeout from k8s api
    Start-Sleep -Seconds 2
}
