#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Update pod
$imageName = If ([bool]$component.psobject.Properties["product"] -and $component.product -ne "") `
                {"$($component.product)-$($component.name)"} Else {"$($component.name)"}
$image = "$($component.registry)/$imageName`:$($component.version)-$($component.build)"
Write-Host "Setting image '$image' for deployment '$($component.name)'"
kubectl set image "deployment/$($component.name)" "$($component.name)=$image"

# Check for success
if ($LASTEXITCODE -ne 0) {
    Write-Error "Can't update '$($component.name)' deployment."
}
