function Resolve-CliTool {
    [CmdletBinding()]
    param (
        [Alias("name")]
        [Parameter(Mandatory = $true, Position = 0)]
        [string] $CliTool
    )

    # Verify cli tools existence by which because script will run on ubuntu
    $CliToolPath = which $CliTool 2>&1

    if ($CliToolPath -match "no $CliTool in") {
        return $False
    }

    return $True
}