#!/usr/bin/env pwsh

param
(
    [Alias("CSProj")]
    [Parameter(Mandatory = $false, Position = 0)]
    [string] $CSProjPath = "src/src.csproj"
)

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Get publish artifact
$dotnetArtifact = $component.artifacts | Where-Object {$_.type -eq "nuget"}

# Skip publish if artifact not set
if ($dotnetArtifact -eq $null) {
    exit 0
}

if (-not (Test-Path -Path "$PSScriptRoot/../../../$CSProjPath")) {
    Write-Error "Can't find .csproj file at '$PSScriptRoot/../../../$CSProjPath'"
}
[xml]$csproj = Get-Content -Path "$PSScriptRoot/../../../$CSProjPath"
if ($csproj.Project.PropertyGroup.PSobject.Properties.name -match "Version") {
    $csprojVersion = $csproj.Project.PropertyGroup.Version
} else {
    $csprojVersion = ($csproj.Project.PropertyGroup | Where-Object {$_.PSobject.Properties.name -match "Version"}).Version
}

# Get publish artifact
$dotnetArtifact = $component.artifacts | Where-Object {$_.type -eq "nuget"}

# Skip publish if artifact not set
if ($dotnetArtifact -eq $null) {
    Write-Host "Didn't find any artifacts of the type 'nuget' in component.json. Publish to nuget skipped."
    exit 0
}

# Verify versions
if ($component.version -ne $csprojVersion) {
    throw "Versions in component.json and $CSProjPath do not match"
}

# Build package before release
dotnet build "$PSScriptRoot/../../../$CSProjPath" -c Release
dotnet pack "$PSScriptRoot/../../../$CSProjPath" -c Release -o "$PSScriptRoot/../../../dist"

$package = (Get-ChildItem -Path "$PSScriptRoot/../../../dist/*.$csprojVersion`.nupkg").FullName

# Push to nuget repo
Write-Host "Pushing $package ..."
dotnet nuget push $package -s "https://www.nuget.org/api/v2/package" -k $env:NUGET_KEY --skip-duplicate

if ($LastExitCode -ne 0) {
    Write-Error "Publish failed. See logs above for more information."
}
