/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.trace;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ErrorDescription;
import org.pipservices4.commons.errors.ErrorDescriptionFactory;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.trace.ITracer;
import org.pipservices4.observability.trace.OperationTrace;
import org.pipservices4.observability.trace.TraceTiming;

public abstract class CachedTracer
implements ITracer,
IReconfigurable,
IReferenceable {
    protected String _source = null;
    protected List<OperationTrace> _cache = new ArrayList<OperationTrace>();
    protected boolean _updated = false;
    protected long _lastDumpTime = System.currentTimeMillis();
    protected int _maxCacheSize = 100;
    protected long _interval = 10000L;

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._interval = config.getAsLongWithDefault("options.interval", this._interval);
        this._maxCacheSize = config.getAsIntegerWithDefault("options.max_cache_size", this._maxCacheSize);
        this._source = config.getAsStringWithDefault("source", this._source);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        ContextInfo contextInfo = (ContextInfo)references.getOneOptional(new Descriptor("pip-services", "context-info", "*", "*", "1.0"));
        if (contextInfo != null && this._source == null) {
            this._source = contextInfo.getName();
        }
    }

    public void write(IContext context, String component, String operation, Exception error, long duration) {
        int pos;
        ErrorDescription errorDesc;
        ErrorDescription errorDescription = errorDesc = error != null ? ErrorDescriptionFactory.create(error) : null;
        if ((operation == null || operation.isEmpty()) && component != null && !component.isEmpty() && (pos = component.lastIndexOf(".")) > 0) {
            operation = component.substring(pos + 1);
            component = component.substring(0, pos);
        }
        OperationTrace trace = new OperationTrace(ZonedDateTime.now(ZoneId.of("UTC")), this._source, component, operation, context != null ? ContextResolver.getTraceId(context) : null, duration, errorDesc);
        this._cache.add(trace);
        this.update();
    }

    @Override
    public void trace(IContext context, String component, String operation, Long duration) {
        this.write(context, component, operation, null, duration);
    }

    @Override
    public void failure(IContext context, String component, String operation, Exception error, long duration) {
        this.write(context, component, operation, error, duration);
    }

    @Override
    public TraceTiming beginTrace(IContext context, String component, String operation) {
        return new TraceTiming(context, component, operation, this);
    }

    public abstract void save(List<OperationTrace> var1);

    public void clear() {
        this._cache = new ArrayList<OperationTrace>();
        this._updated = false;
    }

    public void dump() {
        block3: {
            if (this._updated) {
                List<OperationTrace> traces = this._cache;
                this._cache = new ArrayList<OperationTrace>();
                try {
                    this.save(traces);
                }
                catch (Exception e) {
                    traces.addAll(this._cache);
                    this._cache = traces;
                    int deleteCount = this._cache.size() - this._maxCacheSize;
                    if (deleteCount <= 0) break block3;
                    this._cache = this._cache.subList(deleteCount, this._cache.size());
                }
            }
        }
    }

    protected void update() {
        this._updated = true;
        if (System.currentTimeMillis() > this._lastDumpTime + this._interval) {
            try {
                this.dump();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

