/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.count;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.count.ICounterTimingCallback;
import org.pipservices4.observability.count.ICounters;

public class CompositeCounters
implements ICounters,
ICounterTimingCallback,
IReferenceable {
    private final List<ICounters> _counters = new ArrayList<ICounters>();

    @Override
    public void setReferences(IReferences references) throws ReferenceException {
        List<Object> counters = references.getOptional(new Descriptor(null, "counters", null, null, null));
        for (Object counter : counters) {
            if (!(counter instanceof ICounters) || counter == this) continue;
            this._counters.add((ICounters)counter);
        }
    }

    @Override
    public CounterTiming beginTiming(String name) {
        return new CounterTiming(name, this);
    }

    @Override
    public void endTiming(String name, float elapsed) {
        for (ICounters counter : this._counters) {
            if (!(counter instanceof ICounterTimingCallback)) continue;
            ((ICounterTimingCallback)((Object)counter)).endTiming(name, elapsed);
        }
    }

    @Override
    public void stats(String name, float value) {
        for (ICounters counter : this._counters) {
            counter.stats(name, value);
        }
    }

    @Override
    public void last(String name, float value) {
        for (ICounters counter : this._counters) {
            counter.last(name, value);
        }
    }

    @Override
    public void timestampNow(String name) {
        this.timestamp(name, ZonedDateTime.now());
    }

    @Override
    public void timestamp(String name, ZonedDateTime value) {
        for (ICounters counter : this._counters) {
            counter.timestamp(name, value);
        }
    }

    @Override
    public void incrementOne(String name) {
        this.increment(name, 1);
    }

    @Override
    public void increment(String name, int value) {
        for (ICounters counter : this._counters) {
            counter.increment(name, value);
        }
    }
}

