/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.grpc.controllers;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ConnectionException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.HttpConnectionResolver;
import org.pipservices4.grpc.commandable.CommandableGrpc;
import org.pipservices4.grpc.commandable.InvokeReply;
import org.pipservices4.grpc.commandable.InvokeRequest;
import org.pipservices4.grpc.controllers.IRegisterable;
import org.pipservices4.grpc.controllers.Interceptor;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.log.CompositeLogger;

public class GrpcEndpoint
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("connection.protocol", "http", "connection.host", "0.0.0.0", "connection.port", 3000, "credential.ssl_key_file", null, "credential.ssl_crt_file", null, "credential.ssl_ca_file", null, "options.maintenance_enabled", false, "options.request_max_size", 0x100000, "options.file_max_size", 0xC800000, "options.connect_timeout", 60000, "options.debug", true);
    protected final List<Interceptor> _interceptors = new ArrayList<Interceptor>();
    private ServerBuilder<? extends ServerBuilder<?>> _builder;
    private Server _server;
    private final HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    private final CompositeLogger _logger = new CompositeLogger();
    private final CompositeCounters _counters = new CompositeCounters();
    private boolean _maintenanceEnabled = false;
    private long _fileMaxSize = 0xC800000L;
    private String _uri;
    private List<IRegisterable> _registrations = new ArrayList<IRegisterable>();

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        config = config.setDefaults(_defaultConfig);
        this._connectionResolver.configure(config);
        this._maintenanceEnabled = config.getAsBooleanWithDefault("options.maintenance_enabled", this._maintenanceEnabled);
        this._fileMaxSize = config.getAsLongWithDefault("options.file_max_size", this._fileMaxSize);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    @Override
    public boolean isOpen() {
        return this._server != null;
    }

    @Override
    public void open(final IContext context) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        ConnectionParams connection = this._connectionResolver.resolve(context);
        this._uri = connection.getAsString("uri");
        int port = connection.getAsInteger("port");
        try {
            if (Objects.equals(connection.getAsStringWithDefault("protocol", "http"), "https")) {
                String sslKeyPath = connection.getAsNullableString("ssl_key_file");
                String sslCrtPath = connection.getAsNullableString("ssl_crt_file");
                String sslCaPath = connection.getAsNullableString("ssl_ca_file");
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(sslCaPath)).keyManager(new File(sslCrtPath), new File(sslKeyPath)).build();
                this._builder = ((NettyServerBuilder)NettyServerBuilder.forPort(port).addService(new CommandableImpl())).sslContext(sslContext);
            } else {
                this._builder = ServerBuilder.forPort(port).addService(new CommandableImpl());
            }
            this.performRegistrations();
            this._server = this._builder.build();
            this._server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GrpcEndpoint.this.close(context);
                }
            });
        }
        catch (Exception ex) {
            this._server = null;
            throw new ConnectionException(ContextResolver.getTraceId(context), "CANNOT_CONNECT", "Opening GRPC service failed").wrap(ex).withDetails("url", this._uri);
        }
    }

    @Override
    public void close(IContext context) {
        if (this._server != null) {
            this._uri = null;
            try {
                this._server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
                this._logger.debug(context, "Closed GRPC service at %s", this._uri);
                this._server = null;
            }
            catch (InterruptedException ex) {
                this._logger.warn(context, "Failed while closing GRPC service: %s", ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public void register(IRegisterable registration) {
        this._registrations.add(registration);
    }

    public void unregister(IRegisterable registration) {
        this._registrations = this._registrations.stream().filter(r -> r != registration).toList();
    }

    private void performRegistrations() throws ReferenceException {
        for (IRegisterable registration : this._registrations) {
            registration.register();
        }
        this._interceptors.forEach(interceptor -> this._builder.intercept((ServerInterceptor)interceptor));
    }

    public void registerService(ServerServiceDefinition service) {
        this._builder.addService(service);
    }

    class CommandableImpl
    extends CommandableGrpc.CommandableImplBase {
        CommandableImpl() {
        }

        @Override
        public void invoke(InvokeRequest request, StreamObserver<InvokeReply> responseObserver) {
            InvokeReply reply = InvokeReply.newBuilder().setResultJsonBytes(request.getArgsJsonBytes()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
    }
}

