/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.grpc.controllers;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.DependencyResolver;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.IUnreferenceable;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.grpc.controllers.CommandFunction;
import org.pipservices4.grpc.controllers.GrpcEndpoint;
import org.pipservices4.grpc.controllers.GrpcFunc;
import org.pipservices4.grpc.controllers.IRegisterable;
import org.pipservices4.grpc.controllers.Interceptor;
import org.pipservices4.grpc.controllers.InterceptorFunc;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.trace.CompositeTracer;
import org.pipservices4.observability.trace.TraceTiming;
import org.pipservices4.rpc.trace.InstrumentTiming;

public abstract class GrpcController
implements IOpenable,
IConfigurable,
IReferenceable,
IUnreferenceable,
IRegisterable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("dependencies.endpoint", "*:endpoint:grpc:*:1.0");
    private final ServerServiceDefinition.Builder _builder;
    private final ServiceDescriptor _serviceDescriptor;
    private final String _serviceName;
    private ConfigParams _config;
    private IReferences _references;
    private boolean _localEndpoint;
    private final IRegisterable _registrable;
    Map<String, CommandFunction> _commandableMethods = new HashMap<String, CommandFunction>();
    private boolean _opened = false;
    protected GrpcEndpoint _endpoint;
    protected DependencyResolver _dependencyResolver = new DependencyResolver(_defaultConfig);
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected CompositeTracer _tracer = new CompositeTracer();

    public GrpcController(ServiceDescriptor serviceDescriptor) {
        this._serviceDescriptor = serviceDescriptor;
        this._serviceName = this._serviceDescriptor.getName();
        this._builder = ServerServiceDefinition.builder(this._serviceName);
        this._registrable = this::registerService;
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._config = config = config.setDefaults(_defaultConfig);
        this._dependencyResolver.configure(config);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._references = references;
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._tracer.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._endpoint = this._dependencyResolver.getOneOptional(GrpcEndpoint.class, "endpoint");
        if (this._endpoint == null) {
            this._endpoint = this.createEndpoint();
            this._localEndpoint = true;
        } else {
            this._localEndpoint = false;
        }
        this._endpoint.register(this._registrable);
    }

    @Override
    public void unsetReferences() {
        if (this._endpoint != null) {
            this._endpoint.unregister(this._registrable);
            this._endpoint = null;
        }
    }

    private GrpcEndpoint createEndpoint() throws ReferenceException, ConfigException {
        GrpcEndpoint endpoint = new GrpcEndpoint();
        if (this._config != null) {
            endpoint.configure(this._config);
        }
        if (this._references != null) {
            endpoint.setReferences(this._references);
        }
        return endpoint;
    }

    protected InstrumentTiming instrument(IContext context, String name) {
        this._logger.trace(context, "Executing %s method", name);
        this._counters.incrementOne(name + ".exec_count");
        CounterTiming counterTiming = this._counters.beginTiming(name + ".exec_time");
        TraceTiming traceTiming = this._tracer.beginTrace(context, name, null);
        return new InstrumentTiming(context, name, "exec", this._logger, this._counters, counterTiming, traceTiming);
    }

    @Override
    public boolean isOpen() {
        return this._opened;
    }

    @Override
    public void open(IContext context) throws ApplicationException {
        if (this._opened) {
            return;
        }
        if (this._endpoint == null) {
            this._endpoint = this.createEndpoint();
            this._endpoint.register(this);
            this._localEndpoint = true;
        }
        if (this._localEndpoint) {
            this._endpoint.open(context);
        }
        this._opened = true;
    }

    @Override
    public void close(IContext context) throws InvalidStateException {
        if (!this._opened) {
            return;
        }
        if (this._endpoint == null) {
            throw new InvalidStateException(ContextResolver.getTraceId(context), "NO_ENDPOINT", "GRPC endpoint is missing");
        }
        if (this._localEndpoint) {
            this._endpoint.close(context);
        }
        this._opened = false;
    }

    private void registerService() {
        this.register();
        if (this._endpoint != null) {
            ServerServiceDefinition serviceDefinitions = this._builder.build();
            this._endpoint.registerService(serviceDefinitions);
        }
    }

    protected void registerInterceptor(InterceptorFunc action) {
        if (this._endpoint == null) {
            return;
        }
        this._endpoint._interceptors.add(new Interceptor(action));
    }

    protected <TRequest extends GeneratedMessageV3, TResponse extends GeneratedMessageV3> void registerMethod(String name, Schema schema, final GrpcFunc<TRequest, StreamObserver<TResponse>> action) {
        ServerCalls.UnaryMethod handler = new ServerCalls.UnaryMethod<TRequest, TResponse>(){

            @Override
            public void invoke(TRequest request, StreamObserver<TResponse> responseObserver) {
                action.apply(request, responseObserver);
            }
        };
        try {
            Optional<MethodDescriptor> method = this._serviceDescriptor.getMethods().stream().filter(m4 -> {
                String[] splitName = m4.getFullMethodName().split("/");
                return splitName.length > 1 && Objects.equals(splitName[1], name);
            }).findFirst();
            MethodDescriptor METHOD_INVOKE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName(this._serviceName, name)).setRequestMarshaller(method.get().getRequestMarshaller()).setResponseMarshaller(method.get().getResponseMarshaller()).build();
            this._builder.addMethod(METHOD_INVOKE, ServerCalls.asyncUnaryCall(handler));
        }
        catch (Exception ex) {
            System.err.println("Error register method");
            throw new RuntimeException(ex);
        }
    }

    @Override
    public abstract void register();
}

