/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.grpc.clients;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.ClientCalls;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ConnectionException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.HttpConnectionResolver;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.trace.CompositeTracer;
import org.pipservices4.observability.trace.TraceTiming;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class GrpcClient
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("connection.protocol", "http", "connection.host", "0.0.0.0", "connection.port", 3000, "options.request_max_size", 0x100000, "options.connect_timeout", 10000, "options.timeout", 10000, "options.retries", 3, "options.debug", true);
    private final ServiceDescriptor _serviceDescriptor;
    protected Channel _channel;
    protected HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected CompositeTracer _tracer = new CompositeTracer();
    protected ConfigParams _options = new ConfigParams();
    protected long _connectTimeout = 10000L;
    protected long _timeout = 10000L;
    protected String _uri;

    public GrpcClient(ServiceDescriptor serviceDescriptor) {
        this._serviceDescriptor = serviceDescriptor;
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        config = config.setDefaults(_defaultConfig);
        this._connectionResolver.configure(config);
        this._options = this._options.override(config.getSection("options"));
        this._connectTimeout = config.getAsLongWithDefault("options.connect_timeout", this._connectTimeout);
        this._timeout = config.getAsLongWithDefault("options.timeout", this._timeout);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._tracer.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    protected InstrumentTiming instrument(IContext context, String name) {
        this._logger.trace(context, "Executing %s method", name);
        this._counters.incrementOne(name + ".call_time");
        CounterTiming counterTiming = this._counters.beginTiming(name + ".call_time");
        TraceTiming traceTiming = this._tracer.beginTrace(context, name, null);
        return new InstrumentTiming(context, name, "exec", this._logger, this._counters, counterTiming, traceTiming);
    }

    @Override
    public boolean isOpen() {
        return this._channel != null;
    }

    @Override
    public void open(IContext context) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        ConnectionParams connection = this._connectionResolver.resolve(context);
        String host = connection.getHost();
        int port = connection.getPort();
        try {
            if (Objects.equals(connection.getAsStringWithDefault("protocol", "http"), "https")) {
                String sslKeyPath = connection.getAsNullableString("ssl_key_file");
                String sslCrtPath = connection.getAsNullableString("ssl_crt_file");
                String sslCaPath = connection.getAsNullableString("ssl_ca_file");
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(sslCaPath)).keyManager(new File(sslCrtPath), new File(sslKeyPath)).build();
                this._channel = NettyChannelBuilder.forAddress(host, port).sslContext(sslContext).build();
            } else {
                this._channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(host, port).usePlaintext()).build();
            }
        }
        catch (Exception ex) {
            this._channel = null;
            throw new ConnectionException(ContextResolver.getTraceId(context), "CANNOT_CONNECT", "Opening GRPC client failed").wrap(ex).withDetails("url", this._uri);
        }
    }

    @Override
    public void close(IContext context) throws ApplicationException {
        if (this._channel != null) {
            try {
                this._logger.debug(context, "Closed GRPC service at %s", this._uri);
            }
            catch (Exception ex) {
                this._logger.warn(context, "Failed while closing GRPC service: %s", ex);
            }
            this._channel = null;
            this._uri = null;
        }
    }

    protected <TRequest, TResponse> TResponse call(String methodName, IContext context, TRequest request) {
        Optional<MethodDescriptor> method = this._serviceDescriptor.getMethods().stream().filter(m4 -> {
            String[] splitName = m4.getFullMethodName().split("/");
            return splitName.length > 1 && Objects.equals(splitName[1], methodName);
        }).findFirst();
        return (TResponse)ClientCalls.blockingUnaryCall(this._channel, method.get(), CallOptions.DEFAULT, request);
    }
}

