/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.tokenizers.generic;

import java.util.Objects;
import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.generic.SymbolNode;

public class SymbolRootNode
extends SymbolNode {
    public SymbolRootNode() {
        super(null, 0);
    }

    public void add(String value, TokenType tokenType) throws Exception {
        if (Objects.equals(value, "")) {
            throw new Exception("Value must have at least 1 character");
        }
        SymbolNode childNode = this.ensureChildWithChar(value.codePointAt(0));
        if (childNode.getTokenType() == TokenType.Unknown) {
            childNode.setValid(true);
            childNode.setTokenType(TokenType.Symbol);
        }
        childNode.addDescendantLine(value.substring(1), tokenType);
    }

    public Token nextToken(IScanner scanner) {
        int nextSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        SymbolNode childNode = this.findChildWithChar(nextSymbol);
        if (childNode != null) {
            childNode = childNode.deepestRead(scanner);
            childNode = childNode.unreadToValid(scanner);
            return new Token(childNode.getTokenType(), childNode.ancestry(), line, column);
        }
        return new Token(TokenType.Symbol, String.valueOf((char)nextSymbol), line, column);
    }
}

