/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.mustache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.expressions.mustache.MustacheException;
import org.pipservices4.expressions.mustache.parsers.MustacheParser;
import org.pipservices4.expressions.mustache.parsers.MustacheToken;
import org.pipservices4.expressions.tokenizers.Token;

public class MustacheTemplate {
    private final Map<String, Object> _defaultVariables = new HashMap<String, Object>();
    private final MustacheParser _parser = new MustacheParser();
    private boolean _autoVariables = true;

    public MustacheTemplate(String template) throws Exception {
        if (template != null) {
            this.setTemplate(template);
        }
    }

    public MustacheTemplate() throws Exception {
    }

    public String getTemplate() {
        return this._parser.getTemplate();
    }

    public void setTemplate(String value) throws Exception {
        this._parser.setTemplate(value);
        if (this._autoVariables) {
            this.createVariables(this._defaultVariables);
        }
    }

    public List<Token> getOriginalTokens() {
        return this._parser.getOriginalTokens();
    }

    public void setOriginalTokens(List<Token> value) throws MustacheException {
        this._parser.setOriginalTokens(value);
        if (this._autoVariables) {
            this.createVariables(this._defaultVariables);
        }
    }

    public boolean getAutoVariables() {
        return this._autoVariables;
    }

    public void setAutoVariables(boolean value) {
        this._autoVariables = value;
    }

    public Map<String, Object> getDefaultVariables() {
        return this._defaultVariables;
    }

    public List<MustacheToken> getInitialTokens() {
        return this._parser.getInitialTokens();
    }

    public List<MustacheToken> getResultTokens() {
        return this._parser.getResultTokens();
    }

    public Object getVariable(Map<String, Object> variables, String name) {
        if (variables == null || name == null) {
            return null;
        }
        name = name.toLowerCase();
        Object result = null;
        for (String propName : variables.keySet()) {
            if (!propName.toLowerCase().equals(name)) continue;
            result = result != null ? result : variables.get(propName);
        }
        return result;
    }

    public void createVariables(Map<String, Object> variables) {
        if (variables == null) {
            return;
        }
        for (String variableName : this._parser.getVariableNames()) {
            boolean found = this.getVariable(variables, variableName) != null;
            if (found) continue;
            variables.put(variableName, null);
        }
    }

    public void clear() {
        this._parser.clear();
        this._defaultVariables.clear();
    }

    public String evaluate() throws MustacheException {
        return this.evaluateWithVariables(null);
    }

    public String evaluateWithVariables(Map<String, Object> variables) throws MustacheException {
        variables = variables != null ? variables : this._defaultVariables;
        return this.evaluateTokens(this._parser.getResultTokens(), variables);
    }

    private boolean isDefinedVariable(Map<String, Object> variables, String name) {
        Object value = this.getVariable(variables, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value != "";
        }
        if (value instanceof Number) {
            Integer res = IntegerConverter.toNullableInteger(value);
            return res != null && res != 0;
        }
        return value != null;
    }

    private String escapeString(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("[\\\\]", "\\\\").replace("[\\\"]", "\\\\\\\"").replace("[\\/]", "\\\\/").replace("[\\b]", "\\\\b").replace("[\\f]", "\\f").replace("[\\n]", "\\n").replace("[\\r]", "\\\\r").replace("[\\t]", "\\t");
    }

    private String evaluateTokens(List<MustacheToken> tokens, Map<String, Object> variables) throws MustacheException {
        if (tokens == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        block9: for (MustacheToken token : tokens) {
            switch (token.getType()) {
                case Comment: {
                    continue block9;
                }
                case Value: {
                    result.append(token.getValue() != null ? token.getValue() : "");
                    continue block9;
                }
                case Variable: {
                    Object value1 = this.getVariable(variables, token.getValue());
                    result.append(value1 != null ? value1 : "");
                    continue block9;
                }
                case EscapedVariable: {
                    Object value2 = this.getVariable(variables, token.getValue());
                    value2 = this.escapeString(String.valueOf(value2));
                    result.append(value2 != null ? value2 : "");
                    continue block9;
                }
                case Section: {
                    boolean defined1 = this.isDefinedVariable(variables, token.getValue());
                    if (!defined1 || token.getTokens() == null) continue block9;
                    result.append(this.evaluateTokens(token.getTokens(), variables));
                    continue block9;
                }
                case InvertedSection: {
                    boolean defined2 = this.isDefinedVariable(variables, token.getValue());
                    if (defined2 || token.getTokens() == null) continue block9;
                    result.append(this.evaluateTokens(token.getTokens(), variables));
                    continue block9;
                }
                case Partial: {
                    throw new MustacheException(null, "PARTIALS_NOT_SUPPORTED", "Partials are not supported", token.getLine(), token.getColumn());
                }
            }
            throw new MustacheException(null, "INTERNAL", "Internal error", token.getLine(), token.getColumn());
        }
        return result.toString();
    }
}

