/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.List;
import org.pipservices4.commons.errors.BadRequestException;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class ValidationException
extends BadRequestException {
    private static final long serialVersionUID = -1459801864235223845L;

    public ValidationException(String traceId, List<ValidationResult> results) {
        this(traceId, ValidationException.composeMessage(results));
        this.withDetails("results", results);
    }

    public ValidationException(String traceId, String message) {
        super(traceId, "INVALID_DATA", message);
    }

    public static String composeMessage(List<ValidationResult> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("Validation failed");
        if (results != null && !results.isEmpty()) {
            boolean first = true;
            for (ValidationResult result : results) {
                if (result.getType() == ValidationResultType.Information) continue;
                if (!first) {
                    builder.append(": ");
                } else {
                    builder.append(", ");
                }
                builder.append(result.getMessage());
                first = false;
            }
        }
        return builder.toString();
    }

    public static ValidationException fromResults(String traceId, List<ValidationResult> results, boolean strict) throws ValidationException {
        boolean hasErrors = false;
        for (ValidationResult result : results) {
            if (result.getType() == ValidationResultType.Error) {
                hasErrors = true;
            }
            if (!strict || result.getType() != ValidationResultType.Warning) continue;
            hasErrors = true;
        }
        return hasErrors ? new ValidationException(traceId, results) : null;
    }

    public static void throwExceptionIfNeeded(String traceId, List<ValidationResult> results, boolean strict) throws ValidationException {
        ValidationException ex = ValidationException.fromResults(traceId, results, strict);
        if (ex != null) {
            throw ex;
        }
    }
}

