/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.commons.reflect.TypeMatcher;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.ValidationException;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class Schema {
    private boolean _required = false;
    private List<IValidationRule> _rules;

    public Schema() {
    }

    public Schema(boolean required, List<IValidationRule> rules) {
        this._required = required;
        this._rules = rules;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean value) {
        this._required = value;
    }

    public List<IValidationRule> getRules() {
        return this._rules;
    }

    public void setRules(List<IValidationRule> value) {
        this._rules = value;
    }

    public Schema makeRequired() {
        this._required = true;
        return this;
    }

    public Schema makeOptional() {
        this._required = false;
        return this;
    }

    public Schema withRule(IValidationRule rule) {
        this._rules = this._rules != null ? this._rules : new ArrayList<IValidationRule>();
        this._rules.add(rule);
        return this;
    }

    protected void performValidation(String path, Object value, List<ValidationResult> results) {
        String name;
        String string = name = path != null ? path : "value";
        if (value == null) {
            if (this._required) {
                results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_IS_NULL", name + " cannot be null", "NOT NULL", null));
            }
        } else {
            value = ObjectReader.getValue(value);
            if (this._rules != null) {
                for (IValidationRule rule : this._rules) {
                    rule.validate(path, this, value, results);
                }
            }
        }
    }

    protected void performTypeValidation(String path, Object type, Object value, List<ValidationResult> results) {
        if (type == null) {
            return;
        }
        if (type instanceof Schema) {
            Schema schema = (Schema)type;
            schema.performValidation(path, value, results);
            return;
        }
        if ((value = ObjectReader.getValue(value)) == null) {
            return;
        }
        String name = path != null ? path : "value";
        Class<?> valueType = value.getClass();
        if (TypeMatcher.matchType(type, TypeConverter.toTypeCode(valueType), value)) {
            return;
        }
        results.add(new ValidationResult(path, ValidationResultType.Error, "TYPE_MISMATCH", name + " type must be " + String.valueOf(type) + " but found " + String.valueOf(valueType), type, valueType));
    }

    public List<ValidationResult> validate(Object value) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        this.performValidation("", value, results);
        return results;
    }

    public void validateAndThrowException(String traceId, Object value, boolean strict) throws ValidationException {
        List<ValidationResult> results = this.validate(value);
        ValidationException.throwExceptionIfNeeded(traceId, results, strict);
    }

    public void validateAndThrowException(String traceId, Object value) throws ValidationException {
        this.validateAndThrowException(traceId, value, false);
    }
}

