/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class OnlyOneExistsRule
implements IValidationRule {
    private final String[] _properties;

    public OnlyOneExistsRule(String ... properties) {
        this._properties = properties;
    }

    @Override
    public void validate(String path, Schema schema, Object value, List<ValidationResult> results) {
        String name = path != null ? path : "value";
        ArrayList<String> found = new ArrayList<String>();
        for (String property : this._properties) {
            Object propertyValue = ObjectReader.getProperty(value, property);
            if (propertyValue == null) continue;
            found.add(property);
        }
        if (found.isEmpty()) {
            results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_NULL", name + " must have at least one property from " + Arrays.toString(this._properties), this._properties, null));
        } else if (found.size() > 1) {
            results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_ONLY_ONE", name + " must have only one property from " + Arrays.toString(this._properties), this._properties, found.toArray()));
        }
    }
}

