/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.lang.reflect.Array;
import java.util.List;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class ArraySchema
extends Schema {
    private Object _valueType;

    public ArraySchema() {
    }

    public ArraySchema(Object valueType) {
        this._valueType = valueType;
    }

    public ArraySchema(Object valueType, boolean required, List<IValidationRule> rules) {
        super(required, rules);
        this._valueType = valueType;
    }

    public Object getValueType() {
        return this._valueType;
    }

    public void setValueType(Object value) {
        this._valueType = value;
    }

    @Override
    protected void performValidation(String path, Object value, List<ValidationResult> results) {
        String name = path != null ? path : "value";
        value = ObjectReader.getValue(value);
        super.performValidation(path, value, results);
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            int index = 0;
            for (Object element : list) {
                String elementPath = path == null || path.isEmpty() ? Integer.toString(index) : path + "." + index;
                this.performTypeValidation(elementPath, this._valueType, element, results);
                ++index;
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object element = Array.get(value, index);
                String elementPath = path == null || path.isEmpty() ? Integer.toString(index) : path + "." + index;
                this.performTypeValidation(elementPath, this._valueType, element, results);
                ++index;
            }
        } else {
            results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_ISNOT_ARRAY", name + " type must be List or Array", "List", value.getClass()));
        }
    }
}

