/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomInteger {
    private static final Random _random = new Random();

    public static int nextInteger(int max) {
        return _random.nextInt(max);
    }

    public static int nextInteger(int min2, int max) {
        if (max - min2 <= 0) {
            return min2;
        }
        return min2 + _random.nextInt(max - min2);
    }

    public static int updateInteger(int value) {
        return RandomInteger.updateInteger(value, 0);
    }

    public static int updateInteger(int value, int range) {
        range = range == 0 ? (int)(0.1 * (double)value) : range;
        int min2 = value - range;
        int max = value + range;
        return RandomInteger.nextInteger(min2, max);
    }

    public static List<Integer> sequence(int size) {
        return RandomInteger.sequence(size, size);
    }

    public static List<Integer> sequence(int min2, int max) {
        int count = RandomInteger.nextInteger(min2, max);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            result.add(i);
        }
        return result;
    }
}

