/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.query;

import org.pipservices4.commons.data.AnyValueMap;

public class TokenizedPagingParams {
    public String token;
    public Integer take;
    public Boolean total;

    public TokenizedPagingParams(String token, Integer take, Boolean total) {
        this.token = token;
        this.take = take;
        this.total = total;
        if (this.take == 0) {
            this.take = null;
        }
    }

    public TokenizedPagingParams() {
    }

    public int getTake(int maxTake) {
        if (this.take == null) {
            return maxTake;
        }
        if (this.take < 0) {
            return 0;
        }
        if (this.take > maxTake) {
            return maxTake;
        }
        return this.take;
    }

    public static TokenizedPagingParams fromValue(Object value) {
        if (value instanceof TokenizedPagingParams) {
            return (TokenizedPagingParams)value;
        }
        AnyValueMap map = AnyValueMap.fromValue(value);
        return TokenizedPagingParams.fromMap(map);
    }

    public static TokenizedPagingParams fromTuples(Object ... tuples) {
        AnyValueMap map = AnyValueMap.fromTuplesArray(tuples);
        return TokenizedPagingParams.fromMap(map);
    }

    public static TokenizedPagingParams fromMap(Object map) {
        AnyValueMap mapValue = AnyValueMap.fromValue(map);
        String token = mapValue.getAsNullableString("token");
        Integer take = mapValue.getAsNullableInteger("take");
        Boolean total = mapValue.getAsBooleanWithDefault("total", false);
        return new TokenizedPagingParams(token, take, total);
    }
}

