/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.pipservices4.components.config.ConfigParams;

public class ConnectionUtils {
    public static ConfigParams concat(ConfigParams options1, ConfigParams options2, List<String> keys) {
        ConfigParams options = ConfigParams.fromValue(options1);
        for (String key : options2.keySet()) {
            String value1 = options1.getAsString(key);
            String value2 = options2.getAsString(key);
            if (!value1.isEmpty() && !value2.isEmpty()) {
                if (keys != null && !keys.isEmpty() && !keys.contains(key)) continue;
                options.setAsObject(key, value1 + "," + value2);
                continue;
            }
            if (value1.isEmpty()) {
                options.setAsObject(key, value1);
                continue;
            }
            options.setAsObject(key, value2);
        }
        return options;
    }

    public static ConfigParams rename(ConfigParams options, String fromName, String toName) {
        Object fromValue = options.getAsObject(fromName);
        if (fromValue == null) {
            return options;
        }
        Object toValue = options.getAsObject(toName);
        if (toValue != null) {
            return options;
        }
        options = ConfigParams.fromValue(options);
        options.setAsObject(toName, fromValue);
        options.remove(fromName);
        return options;
    }

    private static String concatValues(String value1, String value2) {
        if (value1 == null || value1.isEmpty()) {
            return value2;
        }
        if (value2 == null || value2.isEmpty()) {
            return value1;
        }
        return value1 + "," + value2;
    }

    public static ConfigParams parseUri(String uri, String defaultProtocol, int defaultPort) {
        String[] servers;
        ConfigParams options = new ConfigParams();
        if (uri == null || uri.isEmpty()) {
            return options;
        }
        int pos = (uri = uri.trim()).indexOf("?");
        if (pos > 0) {
            String[] paramsList;
            String params = uri.substring(pos + 1);
            uri = uri.substring(0, pos);
            String[] stringArray = paramsList = params.split("&");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                pos = param.indexOf("=");
                if (pos >= 0) {
                    String key = URLDecoder.decode(param.substring(0, pos), StandardCharsets.UTF_8);
                    String value = URLDecoder.decode(param.substring(pos + 1), StandardCharsets.UTF_8);
                    options.setAsObject(key, value);
                    continue;
                }
                options.setAsObject(URLDecoder.decode(param, StandardCharsets.UTF_8), null);
            }
        }
        if ((pos = uri.indexOf("://")) > 0) {
            String protocol = uri.substring(0, pos);
            uri = uri.substring(pos + 3);
            options.setAsObject("protocol", protocol);
        } else {
            options.setAsObject("protocol", defaultProtocol);
        }
        pos = uri.indexOf("@");
        if (pos > 0) {
            String userAndPass = uri.substring(0, pos);
            uri = uri.substring(pos + 1);
            pos = userAndPass.indexOf(":");
            if (pos > 0) {
                options.setAsObject("username", userAndPass.substring(0, pos));
                options.setAsObject("password", userAndPass.substring(pos + 1));
            } else {
                options.setAsObject("username", userAndPass);
            }
        }
        if ((pos = uri.indexOf("/")) > 0) {
            String path = uri.substring(pos + 1);
            uri = uri.substring(0, pos);
            options.setAsObject("path", path);
        }
        for (String server : servers = uri.split(",")) {
            pos = server.indexOf(":");
            if (pos > 0) {
                options.setAsObject("servers", ConnectionUtils.concatValues(options.getAsString("servers"), server));
                options.setAsObject("host", ConnectionUtils.concatValues(options.getAsString("host"), server.substring(0, pos)));
                options.setAsObject("port", ConnectionUtils.concatValues(options.getAsString("port"), server.substring(pos + 1)));
                continue;
            }
            options.setAsObject("servers", ConnectionUtils.concatValues(options.getAsString("servers"), server + ":" + defaultPort));
            options.setAsObject("host", ConnectionUtils.concatValues(options.getAsString("host"), server));
            options.setAsObject("port", ConnectionUtils.concatValues(options.getAsString("port"), String.valueOf(defaultPort)));
        }
        return options;
    }

    public static String composeUri(ConfigParams options, String defaultProtocol, int defaultPort) {
        String username;
        StringBuilder builder = new StringBuilder();
        String protocol = options.getAsStringWithDefault("protocol", defaultProtocol);
        if (protocol != null) {
            builder.append(protocol + "://" + String.valueOf(builder));
        }
        if ((username = options.getAsNullableString("username")) != null) {
            builder.append(username);
            String password = options.getAsNullableString("password");
            if (password != null) {
                builder.append(":" + password);
            }
            builder.append("@");
        }
        StringBuilder servers = new StringBuilder();
        String defaultPortStr = defaultPort > 0 ? String.valueOf(defaultPort) : "";
        String[] hosts = options.getAsStringWithDefault("host", "???").split(",");
        String[] ports = options.getAsStringWithDefault("port", defaultPortStr).split(",");
        for (int index = 0; index < hosts.length; ++index) {
            if (!servers.isEmpty()) {
                servers.append(",");
            }
            String host = hosts[index];
            servers.append(host);
            String port = ports.length > index ? ports[index] : defaultPortStr;
            String string = port = !port.isEmpty() ? port : defaultPortStr;
            if (port.isEmpty()) continue;
            servers.append(":").append(port);
        }
        builder.append((CharSequence)servers);
        String path = options.getAsNullableString("path");
        if (path != null) {
            builder.append("/").append(path);
        }
        StringBuilder params = new StringBuilder();
        List<String> reservedKeys = List.of("protocol", "host", "port", "username", "password", "servers", "path");
        for (String key : options.getKeys()) {
            if (reservedKeys.contains(key)) continue;
            if (!params.isEmpty()) {
                params.append("&");
            }
            params.append(URLDecoder.decode(key, StandardCharsets.UTF_8));
            String value = options.getAsNullableString(key);
            if (value == null || value.isEmpty()) continue;
            params.append("=").append(URLDecoder.decode(value, StandardCharsets.UTF_8));
        }
        if (!params.isEmpty()) {
            builder.append("?").append((CharSequence)params);
        }
        return builder.toString();
    }

    public static ConfigParams include(ConfigParams options, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return options;
        }
        ConfigParams result = new ConfigParams();
        for (String key : options.getKeys()) {
            if (!keys.contains(key)) continue;
            result.setAsObject(key, options.getAsString(key));
        }
        return result;
    }

    public static ConfigParams exclude(ConfigParams options, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return options;
        }
        ConfigParams result = (ConfigParams)options.clone();
        for (String key : keys) {
            result.remove(key);
        }
        return result;
    }
}

