/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.pipservices4.commons.data.StringValueMap;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;

public final class ContextInfo
implements IReconfigurable {
    private String _name = "unknown";
    private StringValueMap _properties = new StringValueMap();
    private String _description = null;
    private String contextId = System.getenv("HOSTNAME") == null ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
    private ZonedDateTime startTime = ZonedDateTime.now(ZoneId.of("UTC"));

    public ContextInfo() {
        this._name = "unknown";
    }

    public ContextInfo(String name, String description) {
        this.setName(name != null ? name : "unknown");
        this.setDescription(description);
    }

    @Override
    public void configure(ConfigParams config) {
        this._name = config.getAsStringWithDefault("name", this._name);
        this._description = config.getAsStringWithDefault("description", this._description);
        this._properties = config.getSection("properties");
    }

    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String _name) {
        this._name = _name != null ? _name : "unknown";
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String _description) {
        this._description = _description;
    }

    @JsonProperty(value="context_id")
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @JsonProperty(value="start_time")
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime != null ? startTime : ZonedDateTime.now(ZoneId.of("UTC"));
    }

    @JsonProperty(value="uptime")
    public long getUptime() {
        return ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli() - this.startTime.toInstant().toEpochMilli();
    }

    @JsonProperty(value="properties")
    public StringValueMap getProperties() {
        return this._properties;
    }

    public void setProperties(StringValueMap _properties) {
        this._properties = _properties;
    }

    public static ContextInfo fromConfig(ConfigParams config) {
        ContextInfo result = new ContextInfo();
        result.configure(config);
        return result;
    }
}

