/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import org.pipservices4.commons.errors.ConfigException;

public class TypeDescriptor {
    private final String _name;
    private final String _library;

    public TypeDescriptor(String name, String library) {
        this._name = name;
        this._library = library;
    }

    public String getName() {
        return this._name;
    }

    public String getLibrary() {
        return this._library;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeDescriptor) {
            TypeDescriptor otherType = (TypeDescriptor)obj;
            if (this.getName() == null || otherType.getName() == null) {
                return false;
            }
            if (!this.getName().equals(otherType.getName())) {
                return false;
            }
            return this.getLibrary() == null || otherType.getLibrary() == null || this.getLibrary().equals(otherType.getLibrary());
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._name);
        if (this._library != null) {
            builder.append(',').append(this._library);
        }
        return builder.toString();
    }

    public static TypeDescriptor fromString(String value) throws ConfigException {
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] tokens = value.split(",");
        if (tokens.length == 1) {
            return new TypeDescriptor(tokens[0].trim(), null);
        }
        if (tokens.length == 2) {
            return new TypeDescriptor(tokens[0].trim(), tokens[1].trim());
        }
        throw (ConfigException)new ConfigException(null, "BAD_DESCRIPTOR", "Type descriptor " + value + " is in wrong format").withDetails("descriptor", value);
    }
}

