/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyReflector {
    private static boolean matchField(Field field, String name) {
        int mod = field.getModifiers();
        return field.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod);
    }

    private static boolean matchPropertyGetter(Method method, String name) {
        if (method.getName().equals("getClass")) {
            return false;
        }
        int mod = method.getModifiers();
        return method.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isAbstract(mod) && method.getParameterCount() == 0;
    }

    private static boolean matchPropertySetter(Method method, String name) {
        int mod = method.getModifiers();
        return method.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isAbstract(mod) && method.getParameterCount() == 1;
    }

    public static boolean hasProperty(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        AccessibleObject[] accessibleObjectArray = objClass.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (PropertyReflector.matchField(field, (String)name)) {
                return true;
            }
            ++n2;
        }
        name = "get" + (String)name;
        accessibleObjectArray = objClass.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (PropertyReflector.matchPropertyGetter((Method)method, (String)name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object getProperty(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        AccessibleObject[] accessibleObjectArray = objClass.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            try {
                if (PropertyReflector.matchField(field, (String)name)) {
                    return field.get(obj);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        name = "get" + (String)name;
        accessibleObjectArray = objClass.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            try {
                if (PropertyReflector.matchPropertyGetter((Method)method, (String)name)) {
                    return ((Method)method).invoke(obj, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getPropertyNames(Object obj) {
        ArrayList<String> properties = new ArrayList<String>();
        Class<?> objClass = obj.getClass();
        AccessibleObject[] accessibleObjectArray = objClass.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (PropertyReflector.matchField(field, field.getName())) {
                properties.add(field.getName());
            }
            ++n2;
        }
        accessibleObjectArray = objClass.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (((Method)method).getName().startsWith("get") && PropertyReflector.matchPropertyGetter((Method)method, ((Method)method).getName())) {
                Object name = ((Method)method).getName().substring(3);
                name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
                properties.add((String)name);
            }
            ++n2;
        }
        return properties;
    }

    public static Map<String, Object> getProperties(Object obj) {
        Object value;
        Object name2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> objClass = obj.getClass();
        AccessibleObject[] accessibleObjectArray = objClass.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            try {
                if (PropertyReflector.matchField(field, field.getName())) {
                    name2 = field.getName();
                    value = field.get(obj);
                    map.put((String)name2, value);
                }
            }
            catch (Throwable name2) {
                // empty catch block
            }
            ++n2;
        }
        accessibleObjectArray = objClass.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            try {
                if (((Method)method).getName().startsWith("get") && PropertyReflector.matchPropertyGetter((Method)method, ((Method)method).getName())) {
                    name2 = ((Method)method).getName().substring(3);
                    name2 = ((String)name2).substring(0, 1).toLowerCase() + ((String)name2).substring(1);
                    value = ((Method)method).invoke(obj, new Object[0]);
                    map.put((String)name2, value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return map;
    }

    public static void setProperty(Object obj, String name, Object value) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        AccessibleObject[] accessibleObjectArray = objClass.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            try {
                if (PropertyReflector.matchField(field, (String)name)) {
                    field.set(obj, value);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        name = "set" + (String)name;
        accessibleObjectArray = objClass.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            try {
                if (PropertyReflector.matchPropertySetter((Method)method, (String)name)) {
                    ((Method)method).invoke(obj, value);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static void setProperties(Object obj, Map<String, Object> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            PropertyReflector.setProperty(obj, entry.getKey(), entry.getValue());
        }
    }
}

