/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pipservices4.commons.convert.ArrayConverter;
import org.pipservices4.commons.convert.BooleanConverter;
import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.DoubleConverter;
import org.pipservices4.commons.convert.DurationConverter;
import org.pipservices4.commons.convert.EnumConverter;
import org.pipservices4.commons.convert.FloatConverter;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.data.AnyValue;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.commons.data.ICloneable;

public class AnyValueArray
extends ArrayList<Object>
implements ICloneable {
    private static final long serialVersionUID = 4856478344826232231L;

    public AnyValueArray() {
    }

    public AnyValueArray(Object[] values) {
        this.append(values);
    }

    public AnyValueArray(Iterable<?> values) {
        this.append(values);
    }

    public Object getAsObject() {
        return new ArrayList<Object>(this);
    }

    public void put(int index, Object value) {
        this.set(index, value);
    }

    public void append(Iterable<?> elements) {
        if (elements != null) {
            for (Object item : elements) {
                this.add(item);
            }
        }
    }

    public void append(Object[] elements) {
        if (elements != null) {
            this.addAll(Arrays.asList(elements));
        }
    }

    public Object getAsObject(int index) {
        return this.get(index);
    }

    public <T> T getAsObject(Class<T> objectType, int index) {
        String strValue = "";
        Object value = this.get(index);
        try {
            if (!(value instanceof String)) {
                strValue = JsonConverter.toJson(value);
            }
            return JsonConverter.fromJson(objectType, strValue);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T getAsObject(TypeReference<T> objectType, int index) {
        String strValue = "";
        Object value = this.get(index);
        try {
            if (!(value instanceof String)) {
                strValue = JsonConverter.toJson(value);
            }
            return JsonConverter.fromJson(objectType, strValue);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAsObject(int index, Object value) {
        if (value == null) {
            value = index;
            this.clear();
            List<Object> elements = ArrayConverter.toArray(value);
            this.append(elements);
        } else {
            this.set(index, value);
        }
    }

    public String getAsNullableString(int index) {
        Object value = this.getAsObject(index);
        return StringConverter.toNullableString(value);
    }

    public String getAsString(int index) {
        return this.getAsStringWithDefault(index, null);
    }

    public String getAsStringWithDefault(int index, String defaultValue) {
        Object value = this.getAsObject(index);
        return StringConverter.toStringWithDefault(value, defaultValue);
    }

    public Boolean getAsNullableBoolean(int index) {
        Object value = this.getAsObject(index);
        return BooleanConverter.toNullableBoolean(value);
    }

    public Boolean getAsBoolean(int index) {
        return this.getAsBooleanWithDefault(index, false);
    }

    public boolean getAsBooleanWithDefault(int index, boolean defaultValue) {
        Object value = this.getAsObject(index);
        return BooleanConverter.toBooleanWithDefault(value, defaultValue);
    }

    public Integer getAsNullableInteger(int index) {
        Object value = this.getAsObject(index);
        return IntegerConverter.toNullableInteger(value);
    }

    public int getAsInteger(int index) {
        return this.getAsIntegerWithDefault(index, 0);
    }

    public int getAsIntegerWithDefault(int index, int defaultValue) {
        Object value = this.getAsObject(index);
        return IntegerConverter.toIntegerWithDefault(value, defaultValue);
    }

    public Long getAsNullableLong(int index) {
        Object value = this.getAsObject(index);
        return LongConverter.toNullableLong(value);
    }

    public long getAsLong(int index) {
        return this.getAsLongWithDefault(index, 0L);
    }

    public long getAsLongWithDefault(int index, long defaultValue) {
        Object value = this.getAsObject(index);
        return LongConverter.toLongWithDefault(value, defaultValue);
    }

    public Float getAsNullableFloat(int index) {
        Object value = this.getAsObject(index);
        return FloatConverter.toNullableFloat(value);
    }

    public float getAsFloat(int index) {
        return this.getAsFloatWithDefault(index, 0.0f);
    }

    public float getAsFloatWithDefault(int index, float defaultValue) {
        Object value = this.getAsObject(index);
        return FloatConverter.toFloatWithDefault(value, defaultValue);
    }

    public Double getAsNullableDouble(int index) {
        Object value = this.getAsObject(index);
        return DoubleConverter.toNullableDouble(value);
    }

    public double getAsDouble(int index) {
        return this.getAsDoubleWithDefault(index, 0.0);
    }

    public double getAsDoubleWithDefault(int index, double defaultValue) {
        Object value = this.getAsObject(index);
        return DoubleConverter.toDoubleWithDefault(value, defaultValue);
    }

    public ZonedDateTime getAsNullableDateTime(int index) {
        Object value = this.getAsObject(index);
        return DateTimeConverter.toNullableDateTime(value);
    }

    public ZonedDateTime getAsDateTime(int index) {
        return this.getAsDateTimeWithDefault(index, null);
    }

    public ZonedDateTime getAsDateTimeWithDefault(int index, ZonedDateTime defaultValue) {
        Object value = this.getAsObject(index);
        return DateTimeConverter.toDateTimeWithDefault(value, defaultValue);
    }

    public Duration getAsNullableDuration(int index) {
        Object value = this.getAsObject(index);
        return DurationConverter.toNullableDuration(value);
    }

    public Duration getAsDuration(int index) {
        return this.getAsDurationWithDefault(index, null);
    }

    public Duration getAsDurationWithDefault(int index, Duration defaultValue) {
        Object value = this.getAsObject(index);
        return DurationConverter.toDurationWithDefault(value, defaultValue);
    }

    public <T extends Enum<T>> T getAsNullableEnum(Class<T> type, int index) {
        Object value = this.getAsObject(index);
        return EnumConverter.toNullableEnum(type, value);
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> type, int index) {
        return this.getAsEnumWithDefault(type, index, null);
    }

    public <T extends Enum<T>> T getAsEnumWithDefault(Class<T> type, int index, T defaultValue) {
        Object value = this.getAsObject(index);
        return EnumConverter.toEnumWithDefault(type, value, defaultValue);
    }

    public <T> T getAsNullableType(Class<T> type, int index) {
        Object value = this.getAsObject(index);
        return TypeConverter.toNullableType(type, value);
    }

    public <T> T getAsType(Class<T> type, int index) {
        return this.getAsTypeWithDefault(type, index, null);
    }

    public <T> T getAsTypeWithDefault(Class<T> type, int index, T defaultValue) {
        Object value = this.getAsObject(index);
        return TypeConverter.toTypeWithDefault(type, value, defaultValue);
    }

    public AnyValue getAsValue(int index) {
        Object value = this.getAsObject(index);
        return new AnyValue(value);
    }

    public AnyValueArray getAsNullableArray(int index) {
        Object value = this.getAsObject(index);
        return value != null ? AnyValueArray.fromValue(value) : null;
    }

    public AnyValueArray getAsArray(int index) {
        Object value = this.getAsObject(index);
        return AnyValueArray.fromValue(value);
    }

    public AnyValueArray getAsArrayWithDefault(int index, AnyValueArray defaultValue) {
        AnyValueArray result = this.getAsNullableArray(index);
        return result != null ? result : defaultValue;
    }

    public AnyValueMap getAsNullableMap(int index) {
        Object value = this.getAsObject(index);
        return value != null ? AnyValueMap.fromValue(value) : null;
    }

    public AnyValueMap getAsMap(int index) {
        Object value = this.getAsObject(index);
        return AnyValueMap.fromValue(value);
    }

    public AnyValueMap getAsMapWithDefault(int index, AnyValueMap defaultValue) {
        AnyValueMap result = this.getAsNullableMap(index);
        return result != null ? AnyValueMap.fromValue(result) : defaultValue;
    }

    @Override
    public boolean contains(Object value) {
        for (Object element : this) {
            if (value == null && element == null) {
                return true;
            }
            if (value == null || element == null || !value.equals(element)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean containsAsType(Class<T> type, Object value) {
        T typedValue = TypeConverter.toType(type, value);
        for (Object thisValue : this) {
            T thisTypedValue = TypeConverter.toNullableType(type, thisValue);
            if (typedValue == null && thisTypedValue == null) {
                return true;
            }
            if (typedValue == null || thisTypedValue == null || !typedValue.equals(thisTypedValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new AnyValueArray(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < this.size()) {
            if (index > 0) {
                builder.append(',');
            }
            builder.append(this.getAsStringWithDefault(index, ""));
            ++index;
        }
        return builder.toString();
    }

    public static AnyValueArray fromValues(Object ... values) {
        return new AnyValueArray(values);
    }

    public static AnyValueArray fromValue(Object value) {
        List<Object> values = ArrayConverter.toNullableArray(value);
        return new AnyValueArray((Iterable<?>)values);
    }

    public static AnyValueArray fromString(String values, String separator, boolean removeDuplicates) {
        String[] items;
        AnyValueArray result = new AnyValueArray();
        if (values == null || values.length() == 0) {
            return result;
        }
        String[] stringArray = items = values.split(separator, -1);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 || !removeDuplicates) {
                result.add(item != null ? new AnyValue(item) : null);
            }
            ++n2;
        }
        return result;
    }

    public static AnyValueArray fromString(String values, String separator) {
        return AnyValueArray.fromString(values, separator, false);
    }
}

